/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    private WeakReference<PropertyChangeListener> weakRef;

    public WeakPropertyChangeListener(PropertyChangeListener target) {
        this.weakRef = new WeakReference<PropertyChangeListener>(target);
    }

    protected void removeFromSource(PropertyChangeEvent event) {
        Object src = event.getSource();
        try {
            src.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class).invoke(src, this);
        }
        catch (Exception ex) {
            InternalError ie = new InternalError("Could not remove WeakPropertyChangeListener from " + String.valueOf(src) + ".");
            ie.initCause(ex);
            throw ie;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PropertyChangeListener listener = (PropertyChangeListener)this.weakRef.get();
        if (listener == null) {
            this.removeFromSource(event);
            return;
        }
        listener.propertyChange(event);
    }

    public PropertyChangeListener getTarget() {
        return (PropertyChangeListener)this.weakRef.get();
    }

    public String toString() {
        return super.toString() + "[" + String.valueOf(this.weakRef.get()) + "]";
    }
}

