/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.color;

import java.awt.image.IndexColorModel;

public class Colors {
    private Colors() {
    }

    public static IndexColorModel createMacColors() {
        int j;
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                for (int k = 0; k < 6; ++k) {
                    r[index] = (byte)(255 - 51 * i);
                    g[index] = (byte)(255 - 51 * j);
                    b[index] = (byte)(255 - 51 * k);
                    ++index;
                }
            }
        }
        --index;
        byte[] ramp = new byte[]{-18, -35, -69, -86, -120, 119, 85, 68, 34, 17};
        for (int i = 0; i < 10; ++i) {
            r[index] = ramp[i];
            g[index] = 0;
            b[index] = 0;
            ++index;
        }
        for (j = 0; j < 10; ++j) {
            r[index] = 0;
            g[index] = ramp[j];
            b[index] = 0;
            ++index;
        }
        for (int k = 0; k < 10; ++k) {
            r[index] = 0;
            g[index] = 0;
            b[index] = ramp[k];
            ++index;
        }
        for (int ijk = 0; ijk < 10; ++ijk) {
            r[index] = ramp[ijk];
            g[index] = ramp[ijk];
            b[index] = ramp[ijk];
            ++index;
        }
        IndexColorModel icm = new IndexColorModel(8, 256, r, g, b);
        return icm;
    }

    public static IndexColorModel createGrayColors() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = (byte)i;
            g[i] = (byte)i;
            b[i] = (byte)i;
        }
        IndexColorModel icm = new IndexColorModel(8, 256, r, g, b);
        return icm;
    }

    private static void RGBtoYCC(float[] rgb, float[] ycc) {
        float R = rgb[0];
        float G = rgb[1];
        float B = rgb[2];
        float Y = 0.3f * R + 0.6f * G + 0.1f * B;
        float V = R - Y;
        float U = B - Y;
        float Cb = U / 2.0f + 0.5f;
        float Cr = V / 1.6f + 0.5f;
        ycc[0] = Y;
        ycc[1] = Cb;
        ycc[2] = Cr;
    }

    private static void YCCtoRGB(float[] ycc, float[] rgb) {
        float Y = ycc[0];
        float Cb = ycc[1];
        float Cr = ycc[2];
        float U = (Cb - 0.5f) * 2.0f;
        float V = (Cr - 0.5f) * 1.6f;
        float R = V + Y;
        float B = U + Y;
        float G = (Y - 0.3f * R - 0.1f * B) / 0.6f;
        rgb[0] = R;
        rgb[1] = G;
        rgb[2] = B;
    }

    private static void RGB8toYCC16(int[] rgb, int[] ycc) {
        int R = rgb[0];
        int G = rgb[1];
        int B = rgb[2];
        int Y = 77 * R + 153 * G + 26 * B;
        int V = R * 256 - Y;
        int U = B * 256 - Y;
        int Cb = U / 2 + 32768;
        int Cr = V * 5 / 8 + 32768;
        ycc[0] = Y;
        ycc[1] = Cb;
        ycc[2] = Cr;
    }

    private static void RGB8toYCC16(int rgb, int[] ycc) {
        int R = (rgb & 0xFF0000) >>> 16;
        int G = (rgb & 0xFF00) >>> 8;
        int B = rgb & 0xFF;
        int Y = 77 * R + 153 * G + 26 * B;
        int V = R * 256 - Y;
        int U = B * 256 - Y;
        int Cb = U / 2 + 32768;
        int Cr = V * 5 / 8 + 32768;
        ycc[0] = Y;
        ycc[1] = Cb;
        ycc[2] = Cr;
    }

    private static void YCC16toRGB8(int[] ycc, int[] rgb) {
        int Y = ycc[0];
        int Cb = ycc[1];
        int Cr = ycc[2];
        int U = (Cb - 32768) * 2;
        int V = (Cr - 32768) * 8 / 5;
        int R = Math.min(255, Math.max(0, (V + Y) / 256));
        int B = Math.min(255, Math.max(0, (U + Y) / 256));
        int G = Math.min(255, Math.max(0, (Y - 77 * R - 26 * B) / 153));
        rgb[0] = R;
        rgb[1] = G;
        rgb[2] = B;
    }

    private static void YCC8toRGB8(int[] ycc, int[] rgb) {
        int Y = ycc[0];
        int Cb = ycc[1];
        int Cr = ycc[2];
        int R = (1000 * Y + 1402 * (Cr - 128)) / 1000;
        int G = (100000 * Y - 34414 * (Cb - 128) - 71414 * (Cr - 128)) / 100000;
        int B = (1000 * Y + 1772 * (Cb - 128)) / 1000;
        rgb[0] = Math.min(255, Math.max(0, R));
        rgb[1] = Math.min(255, Math.max(0, G));
        rgb[2] = Math.min(255, Math.max(0, B));
    }

    private static void RGB8toYCC8(int[] rgb, int[] ycc) {
        int R = rgb[0];
        int G = rgb[1];
        int B = rgb[2];
        int Y = (299 * R + 587 * G + 114 * B) / 1000;
        int Cb = (-1687 * R - 3313 * G + 5000 * B) / 10000 + 128;
        int Cr = (5000 * R - 4187 * G - 813 * B) / 10000 + 128;
        ycc[0] = Math.min(255, Math.max(0, Y));
        ycc[1] = Math.min(255, Math.max(0, Cb));
        ycc[2] = Math.min(255, Math.max(0, Cr));
    }
}

