/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.monte.media.color.ColorModels;
import org.monte.media.color.Histogram;
import org.monte.media.image.Images;
import org.monte.media.math.LinearEquations;

public class WhiteBalance {
    private WhiteBalance() {
    }

    public static BufferedImage whiteBalanceGreyworld(BufferedImage img) {
        img = Images.toIntImage(img);
        Histogram hist = new Histogram();
        hist.countPixels(img.getRaster());
        double[] m = WhiteBalance.whiteBalanceGreyworld(hist);
        BufferedImage out = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        int[] p = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int[] q = ((DataBufferInt)out.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < p.length; ++i) {
            int px = p[i];
            double R = (px & 0xFF0000) >> 16;
            double G = (px & 0xFF00) >> 8;
            double B = (px & 0xFF) >> 0;
            double Rq = m[0] * R + m[1] * B + m[2] * G;
            double Gq = m[3] * R + m[4] * B + m[5] * G;
            double Bq = m[6] * R + m[7] * B + m[8] * G;
            q[i] = (Math.min(255, Math.max(0, (int)Rq)) & 0xFF) << 16 | (Math.min(255, Math.max(0, (int)Gq)) & 0xFF) << 8 | (Math.min(255, Math.max(0, (int)Bq)) & 0xFF) << 0;
        }
        return out;
    }

    public static BufferedImage whiteBalanceGreyworldYCC(BufferedImage img, float[] ccAdjust, boolean all) {
        img = Images.toIntImage(img);
        Histogram hist = new Histogram();
        hist.countPixels(img.getRaster());
        double[] m = WhiteBalance.whiteBalanceGreyworld(hist);
        int[] p = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        float[] rgb = new float[3];
        float[] ycc = new float[3];
        float T = 0.097f;
        int NGray = 0;
        int NColor = 0;
        double cbGraySum = 0.0;
        double cbColorSum = 0.0;
        double crGraySum = 0.0;
        double crColorSum = 0.0;
        for (int i = 0; i < p.length; ++i) {
            int px = p[i];
            rgb[0] = (float)((px & 0xFF0000) >> 16) / 255.0f;
            rgb[1] = (float)((px & 0xFF00) >> 8) / 255.0f;
            rgb[2] = (float)((px & 0xFF) >> 0) / 255.0f;
            ColorModels.RGBtoYCC(rgb, ycc);
            if ((Math.abs(ycc[1]) + Math.abs(ycc[2])) / ycc[0] > T) {
                ++NColor;
                cbColorSum += (double)ycc[1];
                crColorSum += (double)ycc[2];
                continue;
            }
            ++NGray;
            cbGraySum += (double)ycc[1];
            crGraySum += (double)ycc[2];
        }
        float cbGrayAdj = -((float)(cbGraySum / (double)NGray));
        float crGrayAdj = -((float)(crGraySum / (double)NGray));
        float cbAllAdj = -((float)(cbColorSum / (double)NColor + cbGraySum / (double)NGray));
        float crAllAdj = -((float)(crColorSum / (double)NColor + crGraySum / (double)NGray));
        float cbAdj = cbGrayAdj;
        float crAdj = crGrayAdj;
        if (all) {
            cbAdj = cbAllAdj;
            crAdj = crAllAdj;
        }
        System.out.println("WhiteBalance.YCC GRAY cb=" + cbGrayAdj + " cr=" + crGrayAdj + " N=" + NGray);
        System.out.println("WhiteBalance.YCC ALL cb=" + cbAllAdj + " cr=" + crAllAdj + " N=" + NColor);
        if (ccAdjust != null) {
            ccAdjust[0] = cbAdj;
            ccAdjust[1] = crAdj;
            return null;
        }
        BufferedImage out = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        int[] q = ((DataBufferInt)out.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < p.length; ++i) {
            int px = p[i];
            rgb[0] = (float)((px & 0xFF0000) >> 16) / 255.0f;
            rgb[1] = (float)((px & 0xFF00) >> 8) / 255.0f;
            rgb[2] = (float)((px & 0xFF) >> 0) / 255.0f;
            ColorModels.RGBtoYCC(rgb, ycc);
            ycc[1] = ycc[1] + cbAdj;
            ycc[2] = ycc[2] + crAdj;
            ColorModels.YCCtoRGB(ycc, rgb);
            q[i] = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f) << 0;
        }
        return out;
    }

    public static BufferedImage whiteBalanceGreyworldYUV(BufferedImage img, float[] uvAdjust, boolean all) {
        img = Images.toIntImage(img);
        Histogram hist = new Histogram();
        hist.countPixels(img.getRaster());
        double[] m = WhiteBalance.whiteBalanceGreyworld(hist);
        int[] p = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        float[] rgb = new float[3];
        float[] yuv = new float[3];
        float T = 0.097f;
        int NGray = 0;
        int NColor = 0;
        double UGraySum = 0.0;
        double UColorSum = 0.0;
        double VGraySum = 0.0;
        double VColorSum = 0.0;
        for (int i = 0; i < p.length; ++i) {
            int px = p[i];
            rgb[0] = (float)((px & 0xFF0000) >> 16) / 255.0f;
            rgb[1] = (float)((px & 0xFF00) >> 8) / 255.0f;
            rgb[2] = (float)((px & 0xFF) >> 0) / 255.0f;
            ColorModels.RGBtoYUV(rgb, yuv);
            if ((Math.abs(yuv[1]) + Math.abs(yuv[2])) / yuv[0] > T) {
                ++NColor;
                UColorSum += (double)yuv[1];
                VColorSum += (double)yuv[2];
                continue;
            }
            ++NGray;
            UGraySum += (double)yuv[1];
            VGraySum += (double)yuv[2];
        }
        float UGrayAdj = -((float)(UGraySum / (double)NGray));
        float VGrayAdj = -((float)(VGraySum / (double)NGray));
        float UAllAdj = -((float)(UColorSum / (double)NColor + UGraySum / (double)NGray));
        float VAllAdj = -((float)(VColorSum / (double)NColor + VGraySum / (double)NGray));
        float UAdj = UGrayAdj;
        float VAdj = VGrayAdj;
        if (all) {
            UAdj = UAllAdj;
            VAdj = VAllAdj;
        }
        System.out.println("WhiteBalance.YUV GRAY cb=" + UGrayAdj + " cr=" + VGrayAdj + " N=" + NGray);
        System.out.println("WhiteBalance.YUV ALL cb=" + UAllAdj + " cr=" + VAllAdj + " N=" + NColor);
        if (uvAdjust != null) {
            uvAdjust[0] = UAdj;
            uvAdjust[1] = VAdj;
            return null;
        }
        BufferedImage out = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        int[] q = ((DataBufferInt)out.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < p.length; ++i) {
            int px = p[i];
            rgb[0] = (float)((px & 0xFF0000) >> 16) / 255.0f;
            rgb[1] = (float)((px & 0xFF00) >> 8) / 255.0f;
            rgb[2] = (float)((px & 0xFF) >> 0) / 255.0f;
            ColorModels.RGBtoYUV(rgb, yuv);
            yuv[1] = yuv[1] + UAdj;
            yuv[2] = yuv[2] + VAdj;
            ColorModels.YUVtoRGB(yuv, rgb);
            q[i] = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f) << 0;
        }
        return out;
    }

    public static BufferedImage whiteBalanceRetinex(BufferedImage img) {
        img = Images.toIntImage(img);
        Histogram hist = new Histogram();
        hist.countPixels(img.getRaster());
        double[] m = WhiteBalance.whiteBalanceRetinex(hist);
        BufferedImage out = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        int[] p = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int[] q = ((DataBufferInt)out.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < p.length; ++i) {
            int px = p[i];
            double R = (px & 0xFF0000) >> 16;
            double G = (px & 0xFF00) >> 8;
            double B = (px & 0xFF) >> 0;
            double Rq = m[0] * R + m[1] * B + m[2] * G;
            double Gq = m[3] * R + m[4] * B + m[5] * G;
            double Bq = m[6] * R + m[7] * B + m[8] * G;
            q[i] = (Math.max(0, (int)Rq) & 0xFF) << 16 | (Math.max(0, (int)Gq) & 0xFF) << 8 | (Math.max(0, (int)Bq) & 0xFF) << 0;
        }
        return out;
    }

    public static BufferedImage whiteBalanceQM(BufferedImage img) {
        img = Images.toIntImage(img);
        Histogram hist = new Histogram();
        hist.countPixels(img.getRaster());
        double[] m = WhiteBalance.whiteBalanceQM(hist);
        BufferedImage out = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        int[] p = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int[] q = ((DataBufferInt)out.getRaster().getDataBuffer()).getData();
        float mur = (float)m[0];
        float nur = (float)m[1];
        float mub = (float)m[2];
        float nub = (float)m[3];
        System.out.println("WhiteBalance QM mur=" + mur + " nur=" + nur + " mub=" + mub + " nub=" + nub);
        for (int i = 0; i < p.length; ++i) {
            int px = p[i];
            double R = (px & 0xFF0000) >> 16;
            double B = (px & 0xFF) >> 0;
            double Rq = (double)mur * R * R + (double)nur * R;
            double Bq = (double)mub * B * B + (double)nub * B;
            q[i] = Math.min(255, Math.max(0, (int)Rq)) << 16 | px & 0xFF00 | Math.min(255, Math.max(0, (int)Bq)) << 0;
        }
        return out;
    }

    public static double[] whiteBalanceGreyworld(Histogram rgbHist) {
        double[] mean_ = rgbHist.getMean();
        double Rmean = mean_[0];
        double Gmean = mean_[1];
        double Bmean = mean_[2];
        double RGBmean = (Rmean + Gmean + Bmean) / 3.0;
        double[] max_ = rgbHist.getHighValue();
        double Rmax = max_[0];
        double Gmax = max_[1];
        double Bmax = max_[2];
        double RGBmax = Math.max(Math.max(Rmax, Gmax), Bmax);
        double fr = RGBmean / Rmean;
        double fg = RGBmean / Bmean;
        double fb = RGBmean / Bmean;
        if (Double.isNaN(fr)) {
            fr = 1.0;
        }
        if (Double.isNaN(fg)) {
            fg = 1.0;
        }
        if (Double.isNaN(fb)) {
            fb = 1.0;
        }
        double[] matrix = new double[]{fr, 0.0, 0.0, 0.0, fg, 0.0, 0.0, 0.0, fb};
        return matrix;
    }

    public static double[] whiteBalanceRetinex(Histogram rgbHist) {
        double[] mean_ = rgbHist.getMean();
        double Rmean = mean_[0];
        double Gmean = mean_[1];
        double Bmean = mean_[2];
        double RGBmean = (Rmean + Gmean + Bmean) / 3.0;
        double[] max_ = rgbHist.getHighValue();
        double Rmax = max_[0];
        double Gmax = max_[1];
        double Bmax = max_[2];
        double RGBmax = Math.max(Math.max(Rmax, Gmax), Bmax);
        double Rgain = Gmax / Rmax;
        double Bgain = Gmax / Bmax;
        if (Double.isNaN(Rgain)) {
            Rgain = 1.0;
        }
        if (Double.isNaN(Bgain)) {
            Bgain = 1.0;
        }
        double[] matrix = new double[]{Rgain, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, Bgain};
        return matrix;
    }

    public static double[] whiteBalanceQM(Histogram rgbHist) {
        int i;
        double[] max_ = rgbHist.getHighValue();
        double Rmax = max_[0];
        double Gmax = max_[1];
        double Bmax = max_[2];
        double R2max = Rmax * Rmax;
        double G2max = Gmax * Gmax;
        double B2max = Bmax * Bmax;
        double Rsum = 0.0;
        double R2sum = 0.0;
        double Gsum = 0.0;
        double Bsum = 0.0;
        double B2sum = 0.0;
        int[] bins = rgbHist.getBins(0);
        for (i = 0; i < bins.length; ++i) {
            Rsum += (double)(bins[i] * i);
            R2sum += (double)(bins[i] * i * i);
        }
        bins = rgbHist.getBins(1);
        for (i = 0; i < bins.length; ++i) {
            Gsum += (double)(bins[i] * i);
        }
        bins = rgbHist.getBins(2);
        for (i = 0; i < bins.length; ++i) {
            Bsum += (double)(bins[i] * i);
            B2sum += (double)(bins[i] * i * i);
        }
        double[] Rmunu = LinearEquations.solve(R2sum, Rsum, R2max, Rmax, Gsum, Gmax);
        double[] Bmunu = LinearEquations.solve(B2sum, Bsum, B2max, Bmax, Gsum, Gmax);
        double[] vector = new double[]{Rmunu[0], Rmunu[1], Bmunu[0], Bmunu[1]};
        return vector;
    }

    public static double[] whiteBalanceQM(long[][] rgbBins) {
        int i;
        double Rmax = 0.0;
        double Gmax = 0.0;
        double Bmax = 0.0;
        double Rsum = 0.0;
        double R2sum = 0.0;
        double Gsum = 0.0;
        double Bsum = 0.0;
        double B2sum = 0.0;
        long[] bins = rgbBins[0];
        for (i = 0; i < bins.length; ++i) {
            Rsum += (double)(bins[i] * (long)i);
            R2sum += (double)(bins[i] * (long)i * (long)i);
            if (bins[i] == 0L) continue;
            Rmax = i;
        }
        bins = rgbBins[1];
        for (i = 0; i < bins.length; ++i) {
            Gsum += (double)(bins[i] * (long)i);
            if (bins[i] == 0L) continue;
            Gmax = i;
        }
        bins = rgbBins[2];
        for (i = 0; i < bins.length; ++i) {
            Bsum += (double)(bins[i] * (long)i);
            B2sum += (double)(bins[i] * (long)i * (long)i);
            if (bins[i] == 0L) continue;
            Bmax = i;
        }
        double R2max = Rmax * Rmax;
        double G2max = Gmax * Gmax;
        double B2max = Bmax * Bmax;
        double[] Rmunu = LinearEquations.solve(R2sum, Rsum, R2max, Rmax, Gsum, Gmax);
        double[] Bmunu = LinearEquations.solve(B2sum, Bsum, B2max, Bmax, Gsum, Gmax);
        double[] vector = new double[]{Rmunu[0], Rmunu[1], Bmunu[0], Bmunu[1]};
        return vector;
    }
}

