/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.imgseq;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.Track;
import org.monte.media.imgseq.FileComparator;
import org.monte.media.math.Rational;

public class ImageSequenceTrack
implements Track {
    private File[] files;
    private int position;
    private long duration = 1L;
    private long timeScale = 30L;
    private final Format format = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO});

    public ImageSequenceTrack(File dir, FileFilter filter) throws IOException {
        this.files = dir.listFiles(filter);
        Arrays.sort(this.files, new FileComparator());
    }

    public ImageSequenceTrack(File[] files) throws IOException {
        this.files = (File[])files.clone();
    }

    public long getFileDuration() {
        return this.duration;
    }

    public void setFileDuration(long newValue) {
        this.duration = newValue;
    }

    public long getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(long newValue) {
        this.timeScale = newValue;
    }

    @Override
    public long getSampleCount() {
        return this.files.length;
    }

    @Override
    public void setPosition(long pos) {
        this.position = (int)pos;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void read(Buffer buf) throws IOException {
        if (this.position >= this.files.length) {
            buf.setFlagsTo(BufferFlag.DISCARD);
            return;
        }
        buf.clearFlags();
        buf.data = this.files[this.position];
        buf.sampleDuration = new Rational(this.duration, this.timeScale);
        ++this.position;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }
}

