/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.io.FilterImageInputStream;

public class QTFFImageInputStream
extends FilterImageInputStream {
    protected static final long MAC_TIMESTAMP_EPOCH = new GregorianCalendar(1904, 0, 1).getTimeInMillis();

    public QTFFImageInputStream(ImageInputStream in) {
        super(in);
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public Date readMacTimestamp() throws IOException {
        long timestamp = (long)this.readInt() & 0xFFFFFFFFL;
        return new Date(MAC_TIMESTAMP_EPOCH + timestamp * 1000L);
    }

    public double readFixed16D16() throws IOException {
        int wholePart = this.readUnsignedShort();
        int fractionPart = this.readUnsignedShort();
        return new Double((double)wholePart + (double)fractionPart / 65536.0);
    }

    public double readFixed2D30() throws IOException {
        int fixed = this.readInt();
        int wholePart = fixed >>> 30;
        int fractionPart = fixed & 0x3FFFFFFF;
        return new Double((double)wholePart + (double)fractionPart / 1.073741823E9);
    }

    public double readFixed8D8() throws IOException {
        int fixed = this.readUnsignedShort();
        int wholePart = fixed >>> 8;
        int fractionPart = fixed & 0xFF;
        return new Double((float)wholePart + (float)fractionPart / 256.0f);
    }

    public String readType() throws IOException {
        this.readFully(this.byteBuf, 0, 4);
        try {
            return new String(this.byteBuf, 0, 4, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }

    public String readPString() throws IOException {
        int size = this.readUnsignedByte();
        if (size == 0) {
            size = this.readUnsignedByte();
            this.skipBytes(2);
        }
        if (size < 0) {
            return "";
        }
        byte[] b = size <= this.byteBuf.length ? this.byteBuf : new byte[size];
        this.readFully(b, 0, size);
        try {
            return new String(b, 0, size, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }

    public String readPString(int fixedSize) throws IOException {
        int remaining = fixedSize;
        int size = this.readUnsignedByte();
        if (size < 0 || size > --remaining) {
            this.skipBytes(remaining);
            return "";
        }
        byte[] b = size <= this.byteBuf.length ? this.byteBuf : new byte[size];
        this.readFully(b, 0, size);
        if (remaining - size > 0) {
            this.skipBytes(remaining - size);
        }
        try {
            return new String(b, 0, size, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }

    public int readUnsignedBCD4() throws IOException {
        this.readFully(this.byteBuf, 0, 2);
        int value = Math.min(9, this.byteBuf[0] >>> 4 & 0xF) * 1000 + Math.min(9, this.byteBuf[1] >>> 0 & 0xF) * 100 + Math.min(9, this.byteBuf[2] >>> 0 & 0xF) * 10 + Math.min(9, this.byteBuf[2] >>> 0 & 0xF) * 1;
        return value;
    }

    public int readUnsignedBCD2() throws IOException {
        this.readFully(this.byteBuf, 0, 1);
        int value = Math.min(9, this.byteBuf[2] >>> 0 & 0xF) * 10 + Math.min(9, this.byteBuf[2] >>> 0 & 0xF) * 1;
        return value;
    }
}

