/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.tiff.IFD;
import org.monte.media.tiff.IFDEntry;

public class TIFFOutputStream
extends OutputStream {
    private ImageOutputStream out;
    private long offset;
    private Stack<IFD> ifdStack = new Stack();
    private State state = State.INITIALIZED;
    private long firstIFDOffset = 8L;

    public TIFFOutputStream(ImageOutputStream out) throws IOException {
        this.out = out;
        this.offset = out.getStreamPosition();
    }

    public void setByteOrder(ByteOrder bo) {
        if (this.state == State.INITIALIZED && bo != this.out.getByteOrder()) {
            throw new IllegalStateException("Can't change byte order within TIFF file");
        }
        this.out.setByteOrder(bo);
    }

    public ByteOrder getByteOrder() {
        return this.out.getByteOrder();
    }

    public long getStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.offset;
    }

    public void seek(long position) throws IOException {
        this.out.seek(position + this.offset);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureStarted();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureStarted();
        this.out.write(b, off, len);
    }

    public void writeIFD(IFD ifd, long nextIFD) throws IOException {
        IFDEntry entry;
        int i;
        this.ensureStarted();
        this.writeSHORT(ifd.getCount());
        long ifdOffset = this.getStreamPosition();
        long valueOffset = this.getStreamPosition() + (long)(12 * ifd.getCount()) + 4L;
        int n = ifd.getCount();
        for (i = 0; i < n; ++i) {
            entry = ifd.get(i);
            this.writeSHORT(entry.getTagNumber());
            this.writeSHORT(entry.getTypeNumber());
            if (entry.isDataInValueOffset()) {
                this.writeLONG(entry.getValueOffset());
                continue;
            }
            this.writeLONG(valueOffset);
            valueOffset += entry.getLength();
        }
        this.writeLONG(nextIFD);
        n = ifd.getCount();
        for (i = 0; i < n; ++i) {
            entry = ifd.get(i);
            if (entry.isDataInValueOffset()) continue;
            this.write((byte[])entry.getData());
        }
    }

    public long getFirstIFDOffset() {
        return this.firstIFDOffset;
    }

    public void setFirstIFDOffset(long newValue) {
        this.firstIFDOffset = newValue;
    }

    private void ensureStarted() throws IOException {
        if (this.state == State.INITIALIZED) {
            if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                this.writeSHORT(18761);
            } else {
                this.writeSHORT(19789);
            }
            this.writeSHORT(42);
            this.state = State.STARTED;
        }
    }

    public void finish() throws IOException {
        this.ensureStarted();
        if (this.state == State.STARTED) {
            this.state = State.FINISHED;
            long pos = this.getStreamPosition();
            this.seek(4L);
            this.writeLONG(this.firstIFDOffset);
            this.seek(pos);
        }
    }

    public void writeLONG(long v) throws IOException {
        this.out.writeInt((int)v);
    }

    public void writeSHORT(int v) throws IOException {
        this.out.writeShort((short)v);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    private static enum State {
        INITIALIZED,
        STARTED,
        FINISHED;

    }
}

