/*
 * Decompiled with CFR 0.152.
 */
package ch.sbb.esta.openshift.gracefullshutdown;

import ch.sbb.esta.openshift.gracefullshutdown.IProbeController;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

class GracefulShutdownHook
implements Runnable {
    protected static final String GRACEFUL_SHUTDOWN_WAIT_SECONDS = "estaGracefulShutdownWaitSeconds";
    private static final String DEFAULT_GRACEFUL_SHUTDOWN_WAIT_SECONDS = "20";
    private static final Log log = LogFactory.getLog(GracefulShutdownHook.class);
    private final ConfigurableApplicationContext applicationContext;

    GracefulShutdownHook(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void run() {
        this.setReadynessToFalse();
        this.delayShutdownSpringContext();
        this.shutdownSpringContext();
    }

    private void shutdownSpringContext() {
        log.info((Object)"Spring Application context starting to shutdown");
        this.applicationContext.close();
        log.info((Object)"Spring Application context is shutdown");
    }

    private void setReadynessToFalse() {
        log.info((Object)"Setting readyness for application to false, so the application doesn't receive new connections from Openshift");
        Map probeControllers = this.applicationContext.getBeansOfType(IProbeController.class);
        if (probeControllers.size() < 1) {
            log.error((Object)("Could not find a ProbeController Bean. Your ProbeController needs to implement the Interface: " + IProbeController.class.getName()));
        }
        if (probeControllers.size() > 1) {
            log.warn((Object)"You have more than one ProbeController for Readyness-Check registered. Most probably one as Rest service and one in automatically configured as Actuator health check.");
        }
        for (IProbeController probeController : probeControllers.values()) {
            probeController.setReady(false);
        }
    }

    private void delayShutdownSpringContext() {
        try {
            int shutdownWaitSeconds = this.getShutdownWaitSeconds();
            log.info((Object)("Gonna wait for " + shutdownWaitSeconds + " seconds before shutdown SpringContext!"));
            Thread.sleep(shutdownWaitSeconds * 1000);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error while gracefulshutdown Thread.sleep", (Throwable)e);
        }
    }

    private int getShutdownWaitSeconds() {
        String waitSeconds = System.getProperty(GRACEFUL_SHUTDOWN_WAIT_SECONDS);
        if (StringUtils.isEmpty((Object)waitSeconds)) {
            waitSeconds = this.applicationContext.getEnvironment().getProperty(GRACEFUL_SHUTDOWN_WAIT_SECONDS, DEFAULT_GRACEFUL_SHUTDOWN_WAIT_SECONDS);
        }
        return Integer.parseInt(waitSeconds);
    }
}

