/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import ch.swaechter.smbjwrapper.SmbConnection;
import ch.swaechter.smbjwrapper.SmbItem;
import ch.swaechter.smbjwrapper.streams.SmbInputStream;
import ch.swaechter.smbjwrapper.streams.SmbOutputStream;
import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.fileinformation.FileStandardInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.transport.TransportException;
import com.hierynomus.smbj.share.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;

public final class SmbFile
extends SmbItem {
    public SmbFile(SmbConnection smbConnection, String pathName) {
        super(smbConnection, pathName);
    }

    public void createFile() {
        File file = this.getDiskShare().openFile(this.getPath(), EnumSet.of(AccessMask.GENERIC_ALL), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, null);
        file.close();
    }

    public void deleteFile() {
        this.getDiskShare().rm(this.getPath());
    }

    public void copyFileViaServerSideCopy(SmbFile destinationSmbFile) throws Buffer.BufferException, TransportException {
        try (File sourceFile = this.getDiskShare().openFile(this.getPath(), EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);
             File destinationFile = this.getDiskShare().openFile(destinationSmbFile.getPath(), EnumSet.of(AccessMask.GENERIC_ALL), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, null);){
            sourceFile.remoteCopyTo(destinationFile);
        }
    }

    public InputStream getInputStream() {
        File file = this.getDiskShare().openFile(this.getPath(), EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);
        return new SmbInputStream(file);
    }

    public OutputStream getOutputStream() {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean appendContent) {
        SMB2CreateDisposition mode = !appendContent ? SMB2CreateDisposition.FILE_OVERWRITE_IF : SMB2CreateDisposition.FILE_OPEN_IF;
        File file = this.getDiskShare().openFile(this.getPath(), EnumSet.of(AccessMask.GENERIC_ALL), null, SMB2ShareAccess.ALL, mode, null);
        return new SmbOutputStream(file, appendContent);
    }

    public long getFileSize() {
        FileStandardInformation fileStandardInformation = this.getDiskShare().getFileInformation(this.getPath()).getStandardInformation();
        return fileStandardInformation.getEndOfFile();
    }

    @Override
    public SmbFile renameTo(String newFileName, boolean replaceIfExist) {
        try (File file = this.getDiskShare().openFile(this.getPath(), EnumSet.of(AccessMask.GENERIC_ALL), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            String newFilePath = this.getParentPath().getPath() + "/" + newFileName;
            file.rename(newFilePath, replaceIfExist);
            SmbFile smbFile = new SmbFile(this.getSmbConnection(), newFilePath);
            return smbFile;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SmbFile) {
            SmbFile smbFile = (SmbFile)object;
            return this.getSmbPath().equals(smbFile.getSmbPath());
        }
        return false;
    }
}

