/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.domain.robstoll.lib.creating.filesystem;

import ch.tutteli.atrium.assertions.Assertion;
import ch.tutteli.atrium.assertions.AssertionGroup;
import ch.tutteli.atrium.assertions.builders.AssertionBuilderKt;
import ch.tutteli.atrium.assertions.builders.AssertionsOption;
import ch.tutteli.atrium.assertions.builders.Explanatory;
import ch.tutteli.atrium.assertions.builders.ExplanatoryAssertionGroupFinalStep;
import ch.tutteli.atrium.assertions.builders.ExplanatoryGroupKt;
import ch.tutteli.atrium.domain.builders.ExpectImpl;
import ch.tutteli.atrium.reporting.translating.Translatable;
import ch.tutteli.atrium.translations.DescriptionPathAssertion;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0001\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0002\u001a \u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a4\u0010\n\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00012!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00050\fH\u0086\b\u001a\u001e\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"addAllLevelResolvedSymlinkHints", "Ljava/nio/file/Path;", "path", "hintList", "Ljava/util/Deque;", "Lch/tutteli/atrium/assertions/Assertion;", "absolutePath", "loopDetection", "Ljava/util/Stack;", "addOneStepResolvedSymlinkHint", "explainForResolvedLink", "resolvedPathAssertionProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "realPath", "hintForLinkLoop", "loop", "", "startIndex", "", "atrium-domain-robstoll-lib-jvm"})
public final class SymbolicLinkResolvingKt {
    @NotNull
    public static final Assertion explainForResolvedLink(@NotNull Path path, @NotNull Function1<? super Path, ? extends Assertion> resolvedPathAssertionProvider) {
        Assertion assertion2;
        int $i$f$explainForResolvedLink = 0;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(resolvedPathAssertionProvider, (String)"resolvedPathAssertionProvider");
        LinkedList<Assertion> hintList = new LinkedList<Assertion>();
        Path realPath = SymbolicLinkResolvingKt.addAllLevelResolvedSymlinkHints(path, (Deque<Assertion>)hintList);
        Assertion resolvedPathAssertion = (Assertion)resolvedPathAssertionProvider.invoke((Object)realPath);
        Collection collection = hintList;
        boolean bl = false;
        if (!collection.isEmpty()) {
            collection = resolvedPathAssertion;
            if (collection instanceof AssertionGroup) {
                hintList.addAll(((AssertionGroup)resolvedPathAssertion).getAssertions());
            } else {
                hintList.add(resolvedPathAssertion);
            }
            ExpectImpl this_$iv = ExpectImpl.INSTANCE;
            boolean $i$f$getBuilder = false;
            assertion2 = ((ExplanatoryAssertionGroupFinalStep)AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithDefaultType().withAssertions((List)hintList)).build();
        } else {
            assertion2 = resolvedPathAssertion;
        }
        return assertion2;
    }

    @PublishedApi
    @NotNull
    public static final Path addAllLevelResolvedSymlinkHints(@NotNull Path path, @NotNull Deque<Assertion> hintList) {
        Path absolutePath;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(hintList, (String)"hintList");
        Path path2 = absolutePath = path.toAbsolutePath().normalize();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"absolutePath");
        return SymbolicLinkResolvingKt.addAllLevelResolvedSymlinkHints(path2, hintList, new Stack<Path>());
    }

    private static final Path addAllLevelResolvedSymlinkHints(Path absolutePath, Deque<Assertion> hintList, Stack<Path> loopDetection) {
        Path currentPath = absolutePath.getRoot();
        for (Path part : absolutePath) {
            int loopDetectionIndex = loopDetection.indexOf(currentPath = currentPath.resolve(part));
            if (loopDetectionIndex != -1) {
                loopDetection.add(currentPath);
                hintList.add(SymbolicLinkResolvingKt.hintForLinkLoop((List<? extends Path>)loopDetection, loopDetectionIndex));
                return absolutePath;
            }
            Path path = currentPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"currentPath");
            Path nextPathAfterFollowSymbolicLink = SymbolicLinkResolvingKt.addOneStepResolvedSymlinkHint(path, hintList);
            if (nextPathAfterFollowSymbolicLink == null) continue;
            loopDetection.push(currentPath);
            currentPath = SymbolicLinkResolvingKt.addAllLevelResolvedSymlinkHints(nextPathAfterFollowSymbolicLink, hintList, loopDetection);
            loopDetection.pop();
        }
        Path path = currentPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"currentPath");
        return path;
    }

    private static final Path addOneStepResolvedSymlinkHint(Path absolutePath, Deque<Assertion> hintList) {
        Path path;
        try {
            ExpectImpl $this$followSymbolicLink$iv;
            Path path2 = absolutePath;
            Iterable<Path> iterable = absolutePath;
            boolean $i$f$followSymbolicLink = false;
            Path path3 = Files.readSymbolicLink((Path)$this$followSymbolicLink$iv);
            Path nextPath = iterable.resolveSibling(path3).normalize();
            $this$followSymbolicLink$iv = ExpectImpl.INSTANCE;
            iterable = hintList;
            boolean $i$f$getBuilder = false;
            path3 = AssertionBuilderKt.getAssertionBuilder();
            Explanatory.ExplanationOption explanationOption = path3.getExplanatory();
            Translatable translatable = (Translatable)DescriptionPathAssertion.HINT_FOLLOWED_SYMBOLIC_LINK;
            Object[] objectArray = new Object[1];
            Path path4 = nextPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"nextPath");
            objectArray[0] = path4;
            iterable.add(explanationOption.withExplanation(translatable, (Object)absolutePath, objectArray).build());
        }
        catch (IOException e) {
            path = null;
        }
        return path;
    }

    private static final Assertion hintForLinkLoop(List<? extends Path> loop, int startIndex) {
        String loopRepresentation = CollectionsKt.joinToString$default((Iterable)loop.subList(startIndex, loop.size()), (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null);
        ExpectImpl this_$iv = ExpectImpl.INSTANCE;
        boolean $i$f$getBuilder = false;
        return ExplanatoryGroupKt.withExplanatoryAssertion((AssertionsOption)AssertionBuilderKt.getAssertionBuilder().getExplanatoryGroup().getWithWarningType(), (Translatable)((Translatable)DescriptionPathAssertion.FAILURE_DUE_TO_LINK_LOOP), (Object)loopRepresentation, (Object[])new Object[0]).build();
    }
}

