/*
 * Decompiled with CFR 0.152.
 */
package ch.ubique.openapi;

import ch.ubique.openapi.CustomPropertyUtils;
import ch.ubique.openapi.wrapper.Documentation;
import ch.ubique.openapi.wrapper.JsonFormat;
import ch.ubique.openapi.wrapper.Mapping;
import ch.ubique.openapi.wrapper.PathVariable;
import ch.ubique.openapi.wrapper.RequestBody;
import ch.ubique.openapi.wrapper.RequestHeader;
import ch.ubique.openapi.wrapper.RequestMapping;
import ch.ubique.openapi.wrapper.RequestParam;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.type.NullType;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.javatuples.Pair;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMethod;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.representer.Representer;

@Mojo(name="springboot-swagger-3", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class SwaggerGenerator
extends AbstractMojo {
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="ch.ubique.viadi", required=true)
    String[] basePackages;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="", required=false)
    String[] blackListedPackages;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="", required=false)
    String[] ignoredTypes;
    @org.apache.maven.plugins.annotations.Parameter(required=true)
    String[] controllers;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="generated/swagger/")
    String outPath;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="swagger.yaml")
    String outFile;
    @org.apache.maven.plugins.annotations.Parameter
    String[] apiUrls;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="1.0-SNAPSHOT")
    String apiVersion;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="API definition generated with the maven plugin")
    String description;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="SwaggerAPI")
    String title;
    Map<String, Object> models = new TreeMap<String, Object>();
    Map<String, Object> paths = new LinkedHashMap<String, Object>();
    private Class<? extends Annotation> requestMapping;
    private Class<? extends Annotation> controller;
    private Class<? extends Annotation> requestParam;
    private Class<? extends Annotation> responseBody;
    private Class<? extends Annotation> requestHeader;
    private Class<? extends Annotation> modelAttribute;
    private Class<? extends Annotation> requestBody;
    private Class<? extends Annotation> jsonIgnore;
    private Class<? extends Annotation> notNull;
    private Class<? extends Annotation> jsonRawValue;
    private Class<? extends Annotation> pathVariable;
    private Class<? extends Annotation> documentation;
    private Class<? extends Annotation> jsonFormat;
    public static Class<? extends Annotation> getMapping;
    public static Class<? extends Annotation> postMapping;
    public static Class<? extends Annotation> putMapping;
    public static Class<? extends Annotation> deleteMapping;
    public static Class<? extends Annotation> patchMapping;
    private URLClassLoader loader;
    private List<String> registeredTypes = new ArrayList<String>();
    static LinkedHashMap<String, String> javaToSwaggerLinkedHashMap;

    private Map<String, Object> getInfoHeader() {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put("version", this.apiVersion);
        info.put("description", this.description);
        info.put("title", this.title);
        return info;
    }

    private List<Map<String, Object>> getServers() {
        ArrayList<Map<String, Object>> servers = new ArrayList<Map<String, Object>>();
        for (String url : this.apiUrls) {
            LinkedHashMap<String, String> server = new LinkedHashMap<String, String>();
            server.put("url", url);
            server.put("description", "");
            servers.add(server);
        }
        return servers;
    }

    private Map<String, Object> getModels() {
        return this.models;
    }

    private void addModel(Class<?> modelClass) {
        for (Map<String, Object> model : this.getModelDefinition("", modelClass)) {
            Set<String> keys = model.keySet();
            ArrayList<String> keysList = new ArrayList<String>(keys);
            this.models.put((String)keysList.get(0), model.values().toArray()[0]);
        }
    }

    private Map<String, Object> getPaths() {
        return this.paths;
    }

    private Map<String, Object> getRequestMethod(Method controllerMethod, RequestMapping wrapper) {
        LinkedHashMap<String, Object> method = new LinkedHashMap<String, Object>();
        method.put("summary", controllerMethod.getName());
        this.getLog().info((CharSequence)"Check if annotation documentation is present");
        this.getLog().info((CharSequence)Arrays.toString(controllerMethod.getAnnotations()));
        if (controllerMethod.isAnnotationPresent(this.documentation)) {
            Documentation docWrapper = new Documentation(controllerMethod.getAnnotation(this.documentation));
            method.put("description", docWrapper.description());
        } else {
            method.put("description", controllerMethod.getName());
        }
        return method;
    }

    private Pair<Class<?>, Integer> resolveList(ParameterizedType type) {
        Class<?> innerClass = null;
        int nestedReturnValueLayer = 0;
        ParameterizedType listType = type;
        while (innerClass == null) {
            innerClass = this.loadClass(listType.getActualTypeArguments()[0].getTypeName());
            if (innerClass == null) {
                if (listType.getActualTypeArguments()[0] instanceof ParameterizedType) {
                    listType = (ParameterizedType)listType.getActualTypeArguments()[0];
                } else {
                    Type innerTmpClass = listType.getActualTypeArguments()[0];
                    if (innerTmpClass instanceof WildcardType) {
                        innerClass = Object.class;
                        this.getLog().warn((CharSequence)"WildcardType don't allow for static Type extraction");
                        break;
                    }
                    innerClass = (Class<?>)listType.getActualTypeArguments()[0];
                    if (innerClass.isArray()) {
                        innerClass = innerClass.getComponentType();
                    }
                }
            }
            ++nestedReturnValueLayer;
        }
        return new Pair(innerClass, (Object)nestedReturnValueLayer);
    }

    private Pair<Class<?>, Integer> getInnerClassFromGeneric(Class<?> container, Type type) throws Exception {
        Class<?> innerClass = null;
        int nestedReturnValueLayer = 0;
        if (type instanceof ParameterizedType) {
            if (Collection.class.isAssignableFrom(container)) {
                String typeName = ((ParameterizedType)type).getActualTypeArguments()[0].getTypeName();
                innerClass = this.loadClass(typeName);
                if (innerClass == null) {
                    Pair<Class<?>, Integer> innerStructure = this.resolveList((ParameterizedType)((ParameterizedType)type).getActualTypeArguments()[0]);
                    innerClass = (Class<?>)innerStructure.getValue0();
                    nestedReturnValueLayer = (Integer)innerStructure.getValue1();
                }
            } else if (Map.class.isAssignableFrom(container)) {
                String keytypeName = ((ParameterizedType)type).getActualTypeArguments()[0].getTypeName();
                String valuetypeName = ((ParameterizedType)type).getActualTypeArguments()[1].getTypeName();
                Class<?> keyClass = this.loadClass(keytypeName);
                if (!this.isPrimitive(keyClass)) {
                    this.getLog().error((CharSequence)"Maps need to have a primitive key type");
                    throw new Exception("Maps need to have a primitive key type");
                }
                innerClass = this.loadClass(valuetypeName);
                if (innerClass == null) {
                    Pair<Class<?>, Integer> innerStructure = this.resolveList((ParameterizedType)type);
                    innerClass = (Class<?>)innerStructure.getValue0();
                    nestedReturnValueLayer = (Integer)innerStructure.getValue1();
                }
            } else {
                String typeName = ((ParameterizedType)type).getActualTypeArguments()[0].getTypeName();
                innerClass = this.loadClass(typeName);
                if (innerClass == null) {
                    Pair<Class<?>, Integer> innerStructure = this.resolveList((ParameterizedType)type);
                    innerClass = (Class)innerStructure.getValue0();
                    nestedReturnValueLayer = (Integer)innerStructure.getValue1() - 1;
                }
            }
        } else if (type instanceof GenericArrayType) {
            String typeName = ((GenericArrayType)type).getGenericComponentType().getTypeName();
            innerClass = this.loadClass(typeName);
        } else {
            innerClass = container;
        }
        return new Pair(innerClass, (Object)nestedReturnValueLayer);
    }

    private boolean hasAcceptHeader(List<String> headers) {
        for (String str : headers) {
            if (!str.contains("Accept=")) continue;
            return true;
        }
        return false;
    }

    private String[] getMimeTypes(List<String> headers) {
        ArrayList strings = new ArrayList();
        for (String str : headers) {
            if (!str.contains("Accept=")) continue;
            String mimes = str.replace("Accept=", "");
            Collections.addAll(strings, (Object[])mimes.split(","));
        }
        String[] returnValue = new String[strings.size()];
        return strings.toArray(returnValue);
    }

    private Map<String, Object> getResponseContent(Class<?> returnType, RequestMapping wrapper, int nestedReturnValueLayer) {
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        String product = "";
        ArrayList<String> headers = new ArrayList<String>();
        Collections.addAll(headers, (Object[])wrapper.headers());
        product = wrapper.produces().length != 0 ? wrapper.produces()[0] : (this.hasAcceptHeader(headers) ? this.getMimeTypes(headers)[0] : (returnType == Byte.TYPE ? "application/octet-stream" : "application/json"));
        content.put(product, new LinkedHashMap());
        Map contentType = (Map)content.get(product);
        Map<String, Object> tmpSchema = new LinkedHashMap<String, Object>();
        contentType.put("schema", tmpSchema);
        if (this.isPrimitive(returnType)) {
            this.mapPrimitiveTypeAndFormat(tmpSchema, returnType.getSimpleName());
        } else if (product.equals("application/octet-stream") || returnType == Byte.TYPE) {
            tmpSchema.put("type", "string");
            tmpSchema.put("format", "binary");
        } else {
            for (int i = 0; i < nestedReturnValueLayer; ++i) {
                tmpSchema.put("type", "array");
                tmpSchema.put("items", new LinkedHashMap());
                tmpSchema = (Map)tmpSchema.get("items");
            }
            tmpSchema.put("$ref", "#/components/schemas/" + returnType.getCanonicalName());
        }
        return content;
    }

    private void addPathsForController(Class<?> controller) throws Exception {
        String baseUrl = "";
        RequestMapping rm = new RequestMapping(this.getRequestMapping(controller));
        if (rm.value().length > 0) {
            baseUrl = baseUrl + rm.value()[0];
        }
        for (Method controllerMethod : SwaggerGenerator.getDeclaredMethodsInOrder(controller)) {
            if (!controllerMethod.isAnnotationPresent(this.requestMapping) && !controllerMethod.isAnnotationPresent(getMapping) && !controllerMethod.isAnnotationPresent(postMapping) && !controllerMethod.isAnnotationPresent(putMapping) && !controllerMethod.isAnnotationPresent(deleteMapping) && !controllerMethod.isAnnotationPresent(patchMapping)) continue;
            RequestMapping wrapper = new RequestMapping(this.getRequestMappingForMethod(controllerMethod));
            Documentation docWrapper = null;
            LinkedHashMap<String, String> returnCodeToDescription = new LinkedHashMap<String, String>();
            if (controllerMethod.isAnnotationPresent(this.documentation)) {
                String[] returnCodes;
                docWrapper = new Documentation(controllerMethod.getAnnotation(this.documentation));
                if (docWrapper.undocumented()) continue;
                for (String response : returnCodes = docWrapper.responses()) {
                    String[] codeToDesc = response.split("=>");
                    if (codeToDesc.length != 2) continue;
                    returnCodeToDescription.put(codeToDesc[0].trim(), codeToDesc[1].trim());
                }
            } else {
                this.getLog().warn((CharSequence)"No Documentation annotation found");
            }
            String path = wrapper.value().length > 0 ? wrapper.value()[0] : (wrapper.path().length > 0 ? wrapper.path()[0] : "");
            this.getLog().warn((CharSequence)path);
            path = !path.startsWith("/") ? baseUrl + "/" + path : baseUrl + path;
            Map request = (Map)this.paths.computeIfAbsent(path, x -> new LinkedHashMap());
            Type returnType = controllerMethod.getGenericReturnType();
            String theMethod = "get";
            this.getLog().error((CharSequence)wrapper.annotationType().toString());
            if (wrapper.method().length > 0) {
                theMethod = wrapper.method()[0].toString().toLowerCase();
            }
            Map method = (Map)request.computeIfAbsent(theMethod, x -> this.getRequestMethod(controllerMethod, wrapper));
            int nestedReturnValueLayer = 0;
            Class actualClass = controllerMethod.getReturnType();
            Pair<Class<?>, Integer> innerStructure = this.getInnerClassFromGeneric(actualClass, returnType);
            actualClass = (Class)innerStructure.getValue0();
            nestedReturnValueLayer = (Integer)innerStructure.getValue1();
            Map responses = (Map)method.computeIfAbsent("responses", x -> new LinkedHashMap());
            if (returnCodeToDescription.isEmpty()) {
                String statusCode = "200";
                Map statusCodeMap = (Map)responses.computeIfAbsent(statusCode, x -> new LinkedHashMap());
                if (returnCodeToDescription.containsKey(statusCode) && !statusCodeMap.containsKey("description")) {
                    statusCodeMap.put("description", returnCodeToDescription.get(statusCode));
                } else {
                    statusCodeMap.put("description", "");
                }
                if (docWrapper != null && docWrapper.responseHeaders() != null) {
                    LinkedHashMap headers = new LinkedHashMap();
                    for (String header : docWrapper.responseHeaders()) {
                        String[] splits = header.split(":");
                        if (splits.length <= 0) continue;
                        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>();
                        LinkedHashMap<String, String> headerSchema = new LinkedHashMap<String, String>();
                        headerSchema.put("type", splits.length >= 3 ? splits[2] : "string");
                        if (splits.length >= 2) {
                            headerMap.put("description", splits[1]);
                        }
                        headerMap.put("schema", headerSchema);
                        headers.put(splits[0], headerMap);
                    }
                    statusCodeMap.put("headers", headers);
                }
                if (statusCode.contains("200") && actualClass != Void.class && !actualClass.getSimpleName().toLowerCase().equals("void")) {
                    if (statusCodeMap.containsKey("content")) {
                        LinkedHashMap innerMap = (LinkedHashMap)statusCodeMap.get("content");
                        innerMap.putAll(this.getResponseContent(actualClass, wrapper, nestedReturnValueLayer));
                    } else {
                        statusCodeMap.put("content", this.getResponseContent(actualClass, wrapper, nestedReturnValueLayer));
                    }
                }
            }
            for (String statusCode : returnCodeToDescription.keySet()) {
                LinkedHashMap<String, Object> statusCodeMap = new LinkedHashMap<String, Object>();
                responses.put(statusCode, statusCodeMap);
                statusCodeMap.put("description", returnCodeToDescription.getOrDefault(statusCode, ""));
                if (docWrapper != null && docWrapper.responseHeaders() != null) {
                    LinkedHashMap headers = new LinkedHashMap();
                    for (String header : docWrapper.responseHeaders()) {
                        String[] splits = header.split(":");
                        if (splits.length <= 0) continue;
                        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>();
                        LinkedHashMap<String, String> headerSchema = new LinkedHashMap<String, String>();
                        headerSchema.put("type", splits.length >= 3 ? splits[2] : "string");
                        if (splits.length >= 2) {
                            headerMap.put("description", splits[1]);
                        }
                        headerMap.put("schema", headerSchema);
                        headers.put(splits[0], headerMap);
                    }
                    statusCodeMap.put("headers", headers);
                }
                if (!statusCode.contains("200") || actualClass == Void.class || actualClass.getSimpleName().toLowerCase().equals("void")) continue;
                statusCodeMap.put("content", this.getResponseContent(actualClass, wrapper, nestedReturnValueLayer));
            }
            this.addModel(actualClass);
            List<Map<String, Object>> parameters = this.getParameters(controllerMethod, wrapper, method);
            if (parameters.size() <= 0) continue;
            method.put("parameters", parameters);
        }
    }

    private Map<String, Object> getRequestParam(Parameter obj) {
        RequestParam wrap = new RequestParam(obj.getAnnotation(this.requestParam));
        String fieldName = wrap.value().isEmpty() ? obj.getName() : wrap.value();
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        param.put("name", fieldName);
        param.put("in", "query");
        if (obj.getAnnotation(this.documentation) != null) {
            Documentation docWrapper = new Documentation(obj.getAnnotation(this.documentation));
            param.put("description", docWrapper.description());
            param.put("example", docWrapper.example());
        } else {
            param.put("description", wrap.name());
        }
        param.put("required", wrap.required());
        param.put("schema", schema);
        if (this.isPrimitive(obj.getType())) {
            this.mapPrimitiveTypeAndFormat(schema, obj.getType().getSimpleName());
        } else if (Collection.class.isAssignableFrom(obj.getType())) {
            schema.put("type", "array");
            schema.put("items", new LinkedHashMap());
            String innerName = ((ParameterizedType)obj.getParameterizedType()).getActualTypeArguments()[0].getTypeName();
            Class<?> inner = this.loadClass(innerName);
            if (this.isPrimitive(inner)) {
                Map itemsMap = (Map)schema.get("items");
                this.mapPrimitiveTypeAndFormat(itemsMap, inner.getSimpleName());
            } else {
                ((Map)schema.get("items")).put("$ref", inner.getCanonicalName());
                this.addModel(inner);
            }
        } else {
            schema.put("$ref", "#/components/schemas/" + obj.getType().getCanonicalName());
            this.addModel(obj.getType());
        }
        return param;
    }

    private Map<String, Object> getPathParam(Parameter obj) {
        PathVariable wrap = new PathVariable(obj.getAnnotation(this.pathVariable));
        String fieldName = wrap.value().isEmpty() ? obj.getName() : wrap.value();
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        param.put("name", fieldName);
        param.put("in", "path");
        if (obj.getAnnotation(this.documentation) != null) {
            Documentation docWrapper = new Documentation(obj.getAnnotation(this.documentation));
            param.put("description", docWrapper.description());
            param.put("example", docWrapper.example());
        } else {
            param.put("description", wrap.name());
        }
        param.put("required", wrap.required());
        param.put("schema", schema);
        if (this.isPrimitive(obj.getType())) {
            this.mapPrimitiveTypeAndFormat(schema, obj.getType().getSimpleName());
        } else if (Collection.class.isAssignableFrom(obj.getType())) {
            schema.put("type", "array");
            schema.put("items", new LinkedHashMap());
            String innerName = ((ParameterizedType)obj.getParameterizedType()).getActualTypeArguments()[0].getTypeName();
            Class<?> inner = this.loadClass(innerName);
            if (this.isPrimitive(inner)) {
                Map itemsMap = (Map)schema.get("items");
                this.mapPrimitiveTypeAndFormat(itemsMap, inner.getSimpleName());
            } else {
                ((Map)schema.get("items")).put("$ref", inner.getCanonicalName());
                this.addModel(inner);
            }
        } else {
            schema.put("$ref", "#/components/schemas/" + obj.getType().getCanonicalName());
            this.addModel(obj.getType());
        }
        return param;
    }

    private Map<String, Object> getRequestHeader(Parameter obj) {
        RequestHeader wrap = new RequestHeader(obj.getAnnotation(this.requestHeader));
        String fieldName = wrap.value().isEmpty() ? obj.getName() : wrap.value();
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        param.put("name", fieldName);
        param.put("in", "header");
        if (obj.getAnnotation(this.documentation) != null) {
            Documentation docWrapper = new Documentation(obj.getAnnotation(this.documentation));
            param.put("description", docWrapper.description());
            param.put("example", docWrapper.example());
        } else {
            param.put("description", wrap.name());
        }
        param.put("required", wrap.required());
        param.put("schema", schema);
        if (this.isPrimitive(obj.getType())) {
            this.mapPrimitiveTypeAndFormat(schema, obj.getType().getSimpleName());
        } else {
            schema.put("$ref", "#/components/schemas/" + obj.getType().getCanonicalName());
            this.addModel(obj.getType());
        }
        return param;
    }

    private Map<String, Object> getRequestBody(Parameter obj, RequestMapping wrapper) {
        String consumes = "";
        consumes = wrapper.consumes().length > 0 ? wrapper.consumes()[0] : "application/json";
        String fieldName = obj.getName();
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> schema = new LinkedHashMap<String, String>();
        if (obj.isAnnotationPresent(this.requestBody)) {
            RequestBody wrap = new RequestBody(obj.getAnnotation(this.requestBody));
            param.put("required", wrap.required());
        }
        param.put("content", new LinkedHashMap());
        if (obj.getAnnotation(this.documentation) != null) {
            Documentation docWrapper = new Documentation(obj.getAnnotation(this.documentation));
            param.put("description", docWrapper.description());
        } else {
            param.put("description", "N/A");
        }
        LinkedHashMap bodyContent = (LinkedHashMap)param.get("content");
        bodyContent.put(consumes, new LinkedHashMap());
        ((LinkedHashMap)bodyContent.get(consumes)).put("schema", schema);
        if (this.isPrimitive(obj.getType())) {
            schema.put("type", javaToSwaggerLinkedHashMap.get(obj.getType().getSimpleName()));
        } else {
            schema.put("$ref", "#/components/schemas/" + obj.getType().getCanonicalName());
            this.addModel(obj.getType());
        }
        return param;
    }

    private List<Map<String, Object>> getParameters(Method controllerMethod, RequestMapping wrapper, Map<String, Object> methodMap) {
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();
        if (controllerMethod.getParameterCount() > 0) {
            for (Parameter obj : controllerMethod.getParameters()) {
                Documentation docWrapper;
                Map<String, Object> param = null;
                if (obj.getAnnotation(this.documentation) != null && (docWrapper = new Documentation(obj.getAnnotation(this.documentation))).undocumented()) continue;
                if (obj.getAnnotation(this.pathVariable) != null) {
                    param = this.getPathParam(obj);
                }
                if (obj.getAnnotation(this.requestParam) != null) {
                    param = this.getRequestParam(obj);
                } else if (obj.getAnnotation(this.requestHeader) != null) {
                    param = this.getRequestHeader(obj);
                } else if (obj.getAnnotation(this.requestBody) != null) {
                    methodMap.put("requestBody", this.getRequestBody(obj, wrapper));
                } else if (obj.getAnnotation(this.modelAttribute) != null) {
                    methodMap.put("requestBody", this.getRequestBody(obj, wrapper));
                }
                if (param == null) continue;
                parameters.add(param);
            }
        }
        return parameters;
    }

    public void execute() throws MojoExecutionException {
        Log logger = this.getLog();
        logger.info((CharSequence)"Get all Classes with a @Controller annotation");
        List<Class<?>> controllerClasses = this.getControllerClasses();
        LinkedHashMap<String, Object> swagger = new LinkedHashMap<String, Object>();
        swagger.put("openapi", "3.0.0");
        swagger.put("servers", this.getServers());
        swagger.put("info", this.getInfoHeader());
        swagger.put("paths", this.getPaths());
        swagger.put("components", new LinkedHashMap());
        ((LinkedHashMap)swagger.get("components")).put("schemas", this.getModels());
        for (Class<?> controller : controllerClasses) {
            logger.info((CharSequence)("Found controller: " + controller.getSimpleName()));
            try {
                this.addPathsForController(controller);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((CharSequence)"All paths added, start writing yaml");
        this.writeYaml(swagger);
    }

    private void writeYaml(Map<String, Object> swagger) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        CustomPropertyUtils customPropertyUtils = new CustomPropertyUtils();
        Representer customRepresenter = new Representer();
        customRepresenter.setPropertyUtils((PropertyUtils)customPropertyUtils);
        Yaml yaml = new Yaml(customRepresenter, options);
        try {
            File directory = new File(this.project.getBasedir(), this.outPath);
            directory.mkdirs();
            File file = new File(directory, this.outFile);
            file.createNewFile();
            FileWriter writer = new FileWriter(file.getAbsolutePath());
            yaml.dump(swagger, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Mapping getRequestMapping(Class<?> controllerClass) {
        Log logger = this.getLog();
        Annotation obj = null;
        RequestMethod method = RequestMethod.GET;
        if (controllerClass.isAnnotationPresent(this.requestMapping)) {
            obj = controllerClass.getAnnotation(this.requestMapping);
            try {
                method = Enum.valueOf(RequestMethod.class, ((Object[])obj.getClass().getMethod("method", null).invoke((Object)obj, null))[0].toString());
            }
            catch (Exception ex) {
                method = RequestMethod.GET;
            }
        }
        if (controllerClass.isAnnotationPresent(getMapping)) {
            obj = controllerClass.getAnnotation(getMapping);
            method = RequestMethod.GET;
        }
        if (controllerClass.isAnnotationPresent(postMapping)) {
            obj = controllerClass.getAnnotation(postMapping);
            method = RequestMethod.POST;
        }
        if (controllerClass.isAnnotationPresent(putMapping)) {
            obj = controllerClass.getAnnotation(putMapping);
            method = RequestMethod.PUT;
        }
        if (controllerClass.isAnnotationPresent(deleteMapping)) {
            obj = controllerClass.getAnnotation(deleteMapping);
            method = RequestMethod.DELETE;
        }
        if (controllerClass.isAnnotationPresent(patchMapping)) {
            obj = controllerClass.getAnnotation(patchMapping);
            method = RequestMethod.PATCH;
        }
        logger.error((CharSequence)((Object)obj).toString());
        return new Mapping(obj, method);
    }

    private Mapping getRequestMappingForMethod(Method controllerClass) {
        Log logger = this.getLog();
        Annotation obj = null;
        RequestMethod method = RequestMethod.GET;
        if (controllerClass.isAnnotationPresent(this.requestMapping)) {
            obj = controllerClass.getAnnotation(this.requestMapping);
            try {
                method = Enum.valueOf(RequestMethod.class, ((Object[])obj.getClass().getMethod("method", null).invoke((Object)obj, null))[0].toString());
            }
            catch (Exception ex) {
                method = RequestMethod.GET;
            }
        }
        if (controllerClass.isAnnotationPresent(getMapping)) {
            obj = controllerClass.getAnnotation(getMapping);
            method = RequestMethod.GET;
        }
        if (controllerClass.isAnnotationPresent(postMapping)) {
            obj = controllerClass.getAnnotation(postMapping);
            method = RequestMethod.POST;
        }
        if (controllerClass.isAnnotationPresent(putMapping)) {
            obj = controllerClass.getAnnotation(putMapping);
            method = RequestMethod.PUT;
        }
        if (controllerClass.isAnnotationPresent(deleteMapping)) {
            obj = controllerClass.getAnnotation(deleteMapping);
            method = RequestMethod.DELETE;
        }
        if (controllerClass.isAnnotationPresent(patchMapping)) {
            obj = controllerClass.getAnnotation(patchMapping);
            method = RequestMethod.PATCH;
        }
        logger.error((CharSequence)((Object)obj).toString());
        return new Mapping(obj, method);
    }

    private Controller getControllerMapping(Class<?> controllerClass) {
        return (Controller)controllerClass.getAnnotation(this.controller);
    }

    private Class<?> loadClass(String name) {
        try {
            return this.loader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private List<Class<?>> getControllerClasses() throws MojoExecutionException {
        ArrayList requestClasses = new ArrayList();
        List classpathElements = null;
        try {
            classpathElements = this.project.getCompileClasspathElements();
            ArrayList<URL> projectClasspathList = new ArrayList<URL>();
            for (String element : classpathElements) {
                if (element.contains(this.project.getBasedir().getAbsolutePath())) {
                    this.getLog().info((CharSequence)("try adding kotlin path to: " + element));
                    String root = element.replace("classes", "kotlin-ic/compile/classes");
                    try {
                        projectClasspathList.add(new File(root).toURI().toURL());
                        this.getLog().info((CharSequence)("Found Kotlin classpath: " + root));
                    }
                    catch (MalformedURLException e) {
                        this.getLog().warn((CharSequence)"No Kotlin class path found");
                        e.printStackTrace();
                    }
                }
                try {
                    projectClasspathList.add(new File(element).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(element + " is an invalid classpath element", (Exception)e);
                }
            }
            this.loader = new URLClassLoader(projectClasspathList.toArray(new URL[0]));
            this.controller = this.loader.loadClass("org.springframework.stereotype.Controller");
            this.requestMapping = this.loader.loadClass("org.springframework.web.bind.annotation.RequestMapping");
            getMapping = this.loader.loadClass("org.springframework.web.bind.annotation.GetMapping");
            postMapping = this.loader.loadClass("org.springframework.web.bind.annotation.PostMapping");
            putMapping = this.loader.loadClass("org.springframework.web.bind.annotation.PutMapping");
            deleteMapping = this.loader.loadClass("org.springframework.web.bind.annotation.DeleteMapping");
            patchMapping = this.loader.loadClass("org.springframework.web.bind.annotation.PatchMapping");
            this.requestParam = this.loader.loadClass("org.springframework.web.bind.annotation.RequestParam");
            this.responseBody = this.loader.loadClass("org.springframework.web.bind.annotation.ResponseBody");
            this.requestHeader = this.loader.loadClass("org.springframework.web.bind.annotation.RequestHeader");
            this.modelAttribute = this.loader.loadClass("org.springframework.web.bind.annotation.ModelAttribute");
            this.requestBody = this.loader.loadClass("org.springframework.web.bind.annotation.RequestBody");
            this.jsonIgnore = this.loader.loadClass("com.fasterxml.jackson.annotation.JsonIgnore");
            this.jsonRawValue = this.loader.loadClass("com.fasterxml.jackson.annotation.JsonRawValue");
            this.jsonFormat = this.loader.loadClass("com.fasterxml.jackson.annotation.JsonFormat");
            this.notNull = this.loader.loadClass("javax.validation.constraints.NotNull");
            this.pathVariable = this.loader.loadClass("org.springframework.web.bind.annotation.PathVariable");
            try {
                this.documentation = this.loader.loadClass("ch.ubique.openapi.docannotations.Documentation");
            }
            catch (ClassNotFoundException ex) {
                this.documentation = Documentation.class;
            }
            for (String classString : this.controllers) {
                Class<?> myclass = this.loader.loadClass(classString);
                if (!myclass.isAnnotationPresent(this.requestMapping)) continue;
                requestClasses.add(myclass);
            }
        }
        catch (DependencyResolutionRequiredException e) {
            new MojoExecutionException("Dependency resolution failed", (Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return requestClasses;
    }

    private String getType(Field field) {
        if (javaToSwaggerLinkedHashMap.containsKey(field.getType().getSimpleName())) {
            return javaToSwaggerLinkedHashMap.get(field.getType().getSimpleName());
        }
        return field.getType().getSimpleName().toLowerCase();
    }

    private Map<String, Object> extractEnum(Class<?> objectClass) {
        try {
            Method m = objectClass.getDeclaredMethod("values", new Class[0]);
            Object[] o = (Object[])m.invoke(null, new Object[0]);
            LinkedHashMap<String, Object> objDef = new LinkedHashMap<String, Object>();
            objDef.put("type", "string");
            objDef.put("enum", new ArrayList());
            for (Object enumType : o) {
                ((ArrayList)objDef.get("enum")).add(enumType.toString());
            }
            return objDef;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addNamedModel(String name, Class<?> model) {
        Collection<Map<String, Object>> innerModDef = this.getModelDefinition(name, model);
        for (Map<String, Object> defi : innerModDef) {
            Set<String> keys = defi.keySet();
            ArrayList<String> keysList = new ArrayList<String>(keys);
            this.models.put((String)keysList.get(0), defi.values().toArray()[0]);
        }
    }

    private List<Field> getAllFields(Class<?> theClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = theClass; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    private Collection<Map<String, Object>> getModelDefinition(String name, Class<?> objectClass) {
        ArrayList<Map<String, Object>> definitions = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Map<String, Object>> topLevel = new LinkedHashMap<String, Map<String, Object>>();
        LinkedHashMap currentObject = new LinkedHashMap();
        if (this.registeredTypes.contains(objectClass.getCanonicalName())) {
            return definitions;
        }
        boolean ownedType = false;
        boolean blackListed = false;
        if (this.blackListedPackages != null) {
            for (String basePackage : this.blackListedPackages) {
                if (!objectClass.getCanonicalName().contains(basePackage)) continue;
                ownedType = false;
                blackListed = true;
                break;
            }
        }
        if (!blackListed) {
            for (String basePackage : this.basePackages) {
                if (!objectClass.getCanonicalName().contains(basePackage)) continue;
                ownedType = true;
                break;
            }
        }
        if (!ownedType && !this.isPrimitive(objectClass)) {
            return definitions;
        }
        this.registeredTypes.add(objectClass.getCanonicalName());
        if (objectClass == Void.class) {
            return definitions;
        }
        if (this.isPrimitive(objectClass)) {
            return definitions;
        }
        if (Enum.class.isAssignableFrom(objectClass)) {
            topLevel.put(objectClass.getCanonicalName(), this.extractEnum(objectClass));
            definitions.add(topLevel);
            return definitions;
        }
        ArrayList<String> required = new ArrayList<String>();
        for (Field field : this.getAllFields(objectClass)) {
            LinkedHashMap<String, String> objDefinition;
            Class<?> type = field.getType();
            if (field.isAnnotationPresent(this.jsonIgnore)) {
                this.getLog().warn((CharSequence)"jsonIgnore");
                continue;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                this.getLog().warn((CharSequence)"static fields are ignored");
                continue;
            }
            if (!this.isPrimitive(type) && this.isBlackListed(type)) {
                this.getLog().warn((CharSequence)"black listed type");
                continue;
            }
            Documentation docWrapper = null;
            if (field.isAnnotationPresent(this.documentation)) {
                docWrapper = new Documentation(field.getAnnotation(this.documentation));
                if (docWrapper.undocumented() && !field.isAnnotationPresent(this.notNull)) continue;
                if (docWrapper.undocumented() && field.isAnnotationPresent(this.notNull)) {
                    this.getLog().warn((CharSequence)"Got undocumented field, which is mandatory! The description of this field will be empty.");
                }
                if (docWrapper.serializedClass() != NullType.class && field.isAnnotationPresent(this.jsonRawValue)) {
                    type = docWrapper.serializedClass();
                }
            }
            if (field.isAnnotationPresent(this.notNull)) {
                required.add(field.getName());
            }
            if (this.isPrimitive(type)) {
                LinkedHashMap<String, Object> innerDef = new LinkedHashMap<String, Object>();
                currentObject.put(field.getName(), innerDef);
                JsonFormat format = field.isAnnotationPresent(this.jsonFormat) ? new JsonFormat(field.getAnnotation(this.jsonFormat)) : null;
                this.mapPrimitiveTypeAndFormat(innerDef, type.getSimpleName(), format, docWrapper);
                if (docWrapper == null) continue;
                innerDef.put("description", docWrapper.description());
                innerDef.put("example", docWrapper.example());
                continue;
            }
            if (Collection.class.isAssignableFrom(type) || type.isArray()) {
                Type innerType;
                LinkedHashMap<String, Object> arraydef = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, String> ref = new LinkedHashMap<String, String>();
                if (field.getGenericType() instanceof ParameterizedType) {
                    innerType = (ParameterizedType)field.getGenericType();
                    Type innerTypeClass = innerType.getActualTypeArguments()[0];
                    String innerTypeName = innerTypeClass.getTypeName();
                    Class<?> actualType = this.loadClass(innerTypeName);
                    if (!this.isPrimitive(actualType)) {
                        this.addNamedModel(field.getName(), actualType);
                        ref.put("$ref", "#/components/schemas/" + actualType.getCanonicalName() + "");
                    } else {
                        ref.put("type", javaToSwaggerLinkedHashMap.get(actualType.getSimpleName()));
                    }
                    arraydef.put("type", "array");
                    arraydef.put("items", ref);
                    if (docWrapper != null) {
                        arraydef.put("description", docWrapper.description());
                    }
                    currentObject.put(field.getName(), arraydef);
                    continue;
                }
                if (!(field.getGenericType() instanceof GenericArrayType)) continue;
                innerType = (GenericArrayType)field.getGenericType();
                String typeName = innerType.getTypeName();
                Class<?> actualClass = this.loadClass(typeName);
                if (!this.isPrimitive(actualClass)) {
                    Collection<Map<String, Object>> innerModDef = this.getModelDefinition(field.getName(), actualClass);
                    for (Map<String, Object> defi : innerModDef) {
                        definitions.add(defi);
                    }
                }
                if (this.isPrimitive(actualClass)) {
                    ref.put("type", javaToSwaggerLinkedHashMap.get(actualClass.getSimpleName()));
                } else {
                    ref.put("$ref", "#/components/schemas/" + actualClass.getCanonicalName() + "");
                }
                arraydef.put("type", "array");
                if (docWrapper != null) {
                    arraydef.put("description", docWrapper.description());
                    arraydef.put("example", docWrapper.example());
                }
                arraydef.put("items", ref);
                currentObject.put(field.getName(), arraydef);
                continue;
            }
            if (Map.class.isAssignableFrom(type)) {
                Log logger = this.getLog();
                String keytypeName = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0].getTypeName();
                String valuetypeName = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1].getTypeName();
                Class<?> keyClass = this.loadClass(keytypeName);
                if (!this.isPrimitive(keyClass)) {
                    logger.error((CharSequence)"Swagger definition does not allow complex keys");
                }
                LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>();
                currentObject.put(field.getName(), objectMap);
                Class<?> actualClass = this.loadClass(valuetypeName);
                objectMap.put("type", "object");
                if (docWrapper != null) {
                    objectMap.put("description", docWrapper.description());
                    objectMap.put("example", docWrapper.example());
                }
                LinkedHashMap<String, Object> addProp = new LinkedHashMap<String, Object>();
                objectMap.put("additionalProperties", addProp);
                if (actualClass == null) {
                    LinkedHashMap<String, Object> lowerLevel = new LinkedHashMap<String, Object>();
                    addProp.put("type", "array");
                    addProp.put("items", lowerLevel);
                    while (actualClass == null) {
                        ParameterizedType listType = (ParameterizedType)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
                        actualClass = this.loadClass(listType.getActualTypeArguments()[0].getTypeName());
                        if (actualClass != null) {
                            lowerLevel.put("$ref", "#/components/schemas/" + actualClass.getCanonicalName() + "");
                            Collection<Map<String, Object>> innerModDef = this.getModelDefinition(field.getName(), actualClass);
                            for (Map<String, Object> defi : innerModDef) {
                                definitions.add(defi);
                            }
                            continue;
                        }
                        lowerLevel.put("type", "array");
                        LinkedHashMap tmp = new LinkedHashMap();
                        lowerLevel.put("items", tmp);
                        lowerLevel = tmp;
                    }
                    continue;
                }
                if (this.isPrimitive(actualClass)) {
                    addProp.put("type", javaToSwaggerLinkedHashMap.get(actualClass.getSimpleName()));
                    continue;
                }
                Collection<Map<String, Object>> innerModDef = this.getModelDefinition(field.getName(), actualClass);
                for (Map<String, Object> defi : innerModDef) {
                    definitions.add(defi);
                }
                addProp.put("$ref", "#/components/schemas/" + actualClass.getCanonicalName());
                continue;
            }
            if (this.isPrimitive(type)) {
                objDefinition = new LinkedHashMap<String, String>();
                currentObject.put(field.getName(), objDefinition);
                objDefinition.put("type", javaToSwaggerLinkedHashMap.get(type.getSimpleName()));
                if (docWrapper == null) continue;
                objDefinition.put("description", docWrapper.description());
                objDefinition.put("example", docWrapper.example());
                continue;
            }
            objDefinition = new LinkedHashMap();
            ArrayList allOfWrapper = new ArrayList();
            LinkedHashMap allOf = new LinkedHashMap();
            allOf.put("allOf", allOfWrapper);
            currentObject.put(field.getName(), allOf);
            objDefinition.put("$ref", "#/components/schemas/" + type.getCanonicalName() + "");
            allOfWrapper.add(objDefinition);
            if (docWrapper != null) {
                LinkedHashMap<String, String> descMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> exampleMap = new LinkedHashMap<String, String>();
                descMap.put("description", docWrapper.description());
                exampleMap.put("example", docWrapper.example());
                allOfWrapper.add(descMap);
                allOfWrapper.add(exampleMap);
            }
            if (this.registeredTypes.contains(type.getSimpleName()) || !ownedType) continue;
            Collection<Map<String, Object>> innerModDef = this.getModelDefinition(field.getName(), type);
            for (Map<String, Object> defi : innerModDef) {
                definitions.add(defi);
            }
        }
        LinkedHashMap<String, Object> objDef = new LinkedHashMap<String, Object>();
        topLevel.put(objectClass.getCanonicalName(), objDef);
        objDef.put("type", "object");
        if (required.size() > 0) {
            objDef.put("required", required);
        }
        objDef.put("properties", currentObject);
        definitions.add(0, topLevel);
        this.getLog().info((CharSequence)("we have " + definitions.size() + " definitions added"));
        return definitions;
    }

    private boolean isPrimitive(Class<?> field) {
        return javaToSwaggerLinkedHashMap.containsKey(field.getSimpleName());
    }

    private boolean isBlackListed(Class<?> field) {
        if (this.blackListedPackages != null) {
            for (String blackListed : this.blackListedPackages) {
                if (!field.getCanonicalName().contains(blackListed)) continue;
                return true;
            }
        }
        if (this.ignoredTypes != null) {
            for (String ignoredType : this.ignoredTypes) {
                if (!field.getCanonicalName().equals(ignoredType)) continue;
                return true;
            }
        }
        return false;
    }

    private void mapPrimitiveTypeAndFormat(Map<String, Object> mapToAdd, String type) {
        String mappedType = javaToSwaggerLinkedHashMap.get(type);
        mapToAdd.put("type", mappedType);
        if (type.equals("double") || type.equals("float") || type.equals("Double") || type.equals("Float")) {
            mapToAdd.put("format", type.toLowerCase());
        } else if (type.equals("long") || type.equals("Long")) {
            mapToAdd.put("format", type.toLowerCase());
        } else if (type.equals("URL")) {
            mapToAdd.put("pattern", "(https?|ftps?|file):\\/\\/((.+\\.)+)[A-z]{2,}((\\/.+)*)");
        }
    }

    private void mapPrimitiveTypeAndFormat(Map<String, Object> mapToAdd, String type, JsonFormat format, Documentation documentation) {
        String mappedType = javaToSwaggerLinkedHashMap.get(type);
        if (format != null) {
            switch (format.shape()) {
                case STRING: {
                    mappedType = "string";
                    if (documentation != null && (documentation == null || documentation.description() != null && !documentation.description().equals(""))) break;
                    mapToAdd.put("pattern", format.pattern());
                    break;
                }
                case NUMBER_INT: {
                    mappedType = "integer";
                    break;
                }
                case NUMBER: 
                case NUMBER_FLOAT: {
                    mappedType = "number";
                    break;
                }
            }
        }
        mapToAdd.put("type", mappedType);
        if (type.equals("double") || type.equals("float") || type.equals("Double") || type.equals("Float")) {
            mapToAdd.put("format", type.toLowerCase());
        } else if (type.equals("long") || type.equals("Long")) {
            mapToAdd.put("format", type.toLowerCase());
        } else if (type.equals("URL")) {
            mapToAdd.put("pattern", "(https?|ftps?|file):\\/\\/((.+\\.)+)[A-z]{2,}((\\/.+)*)");
        }
    }

    public static Method[] getDeclaredMethodsInOrder(Class clazz) {
        Method[] methods = null;
        try {
            int i;
            int cde;
            byte[] block;
            int n;
            String resource = clazz.getName().replace('.', '/') + ".class";
            methods = clazz.getDeclaredMethods();
            InputStream is = clazz.getClassLoader().getResourceAsStream(resource);
            if (is == null) {
                return methods;
            }
            Arrays.sort(methods, new ByLength());
            ArrayList<byte[]> blocks = new ArrayList<byte[]>();
            int length = 0;
            while ((n = is.read(block = new byte[16384])) > 0) {
                if (n < block.length) {
                    block = Arrays.copyOf(block, n);
                }
                length += block.length;
                blocks.add(block);
            }
            byte[] data = new byte[length];
            int offset = 0;
            for (byte[] block2 : blocks) {
                System.arraycopy(block2, 0, data, offset, block2.length);
                offset += block2.length;
            }
            String sdata = new String(data, Charset.forName("UTF-8"));
            int lnt = sdata.indexOf("LineNumberTable");
            if (lnt != -1) {
                sdata = sdata.substring(lnt + "LineNumberTable".length() + 3);
            }
            if ((cde = sdata.lastIndexOf("SourceFile")) != -1) {
                sdata = sdata.substring(0, cde);
            }
            Object[] mo = new MethodOffset[methods.length];
            for (i = 0; i < methods.length; ++i) {
                int pos = -1;
                while ((pos = sdata.indexOf(methods[i].getName(), pos)) != -1) {
                    boolean subset = false;
                    for (int j = 0; j < i; ++j) {
                        if (((MethodOffset)mo[j]).offset < 0 || ((MethodOffset)mo[j]).offset > pos || pos >= ((MethodOffset)mo[j]).offset + ((MethodOffset)mo[j]).method.getName().length()) continue;
                        subset = true;
                        break;
                    }
                    if (!subset) break;
                    pos += methods[i].getName().length();
                }
                mo[i] = new MethodOffset(methods[i], pos);
            }
            Arrays.sort(mo);
            for (i = 0; i < mo.length; ++i) {
                methods[i] = ((MethodOffset)mo[i]).method;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return methods;
    }

    static {
        javaToSwaggerLinkedHashMap = new LinkedHashMap();
        javaToSwaggerLinkedHashMap.put("DateTime", "integer");
        javaToSwaggerLinkedHashMap.put("Date", "integer");
        javaToSwaggerLinkedHashMap.put("Double", "number");
        javaToSwaggerLinkedHashMap.put("double", "number");
        javaToSwaggerLinkedHashMap.put("Float", "number");
        javaToSwaggerLinkedHashMap.put("float", "number");
        javaToSwaggerLinkedHashMap.put("String", "string");
        javaToSwaggerLinkedHashMap.put("int", "integer");
        javaToSwaggerLinkedHashMap.put("Integer", "integer");
        javaToSwaggerLinkedHashMap.put("boolean", "boolean");
        javaToSwaggerLinkedHashMap.put("Boolean", "boolean");
        javaToSwaggerLinkedHashMap.put("Long", "integer");
        javaToSwaggerLinkedHashMap.put("long", "integer");
        javaToSwaggerLinkedHashMap.put("Object", "object");
        javaToSwaggerLinkedHashMap.put("Void", "");
        javaToSwaggerLinkedHashMap.put("void", "");
        javaToSwaggerLinkedHashMap.put("URL", "string");
    }

    static class ByLength
    implements Comparator<Method> {
        ByLength() {
        }

        @Override
        public int compare(Method a, Method b) {
            return b.getName().length() - a.getName().length();
        }
    }

    static class MethodOffset
    implements Comparable<MethodOffset> {
        Method method;
        int offset;

        MethodOffset(Method _method, int _offset) {
            this.method = _method;
            this.offset = _offset;
        }

        @Override
        public int compareTo(MethodOffset target) {
            return this.offset - target.offset;
        }
    }
}

