/*
 * Decompiled with CFR 0.152.
 */
package eu.soupmc;

import com.google.gson.Gson;
import de.dytanic.cloudnet.ext.bridge.bukkit.BukkitCloudNetHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class GameAPI {
    public Class<? extends JavaPlugin> plugin;
    public static GameAPI instance;

    public GameAPI(Class<? extends JavaPlugin> passedPlugin) {
        this.plugin = passedPlugin;
        instance = this;
        Bukkit.getConsoleSender().sendMessage("------ Hello from the GameApi ------");
        Bukkit.getConsoleSender().sendMessage("------ Developed by jobebe07  ------");
    }

    public void setIngameStatus() {
        BukkitCloudNetHelper.changeToIngame();
    }

    public void setMaxPlayers(int maxPlayers) {
        BukkitCloudNetHelper.setMaxPlayers((int)maxPlayers);
    }

    public int getMaxPlayers() {
        return BukkitCloudNetHelper.getMaxPlayers();
    }

    protected static void addXp(Player player, int xp) {
        instance.request("write", "addXP", player.getUniqueId(), "" + xp);
    }

    protected static int getXp(Player p) {
        Gson gson = new Gson();
        Map response = (Map)gson.fromJson(instance.request("read", "getXP", p.getUniqueId(), ""), HashMap.class);
        return Integer.parseInt((String)response.get("result"));
    }

    protected static void addCoins(Player player, int coins) {
        instance.request("write", "addCoins", player.getUniqueId(), "" + coins);
    }

    protected static int getCoins(Player p) {
        Gson gson = new Gson();
        Map response = (Map)gson.fromJson(instance.request("read", "getCoins", p.getUniqueId(), ""), HashMap.class);
        return Integer.parseInt((String)response.get("result"));
    }

    protected static String getNick(Player p) {
        Gson gson = new Gson();
        Map response = (Map)gson.fromJson(instance.request("read", "getNick", p.getUniqueId(), ""), HashMap.class);
        return ((String)response.get("result")).trim();
    }

    protected static void setNick(Player p, boolean value) {
        instance.request("write", "setNick", p.getUniqueId(), value ? "true" : "false");
    }

    protected String request(String type, String key, UUID uuid, String amount) {
        HttpPost postRequest = new HttpPost("https://belinked.chat/soupmcGameApi.php");
        DefaultHttpClient httpClient = new DefaultHttpClient();
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair("type", type));
        nameValuePairs.add(new BasicNameValuePair("key", key));
        nameValuePairs.add(new BasicNameValuePair("player", uuid.toString()));
        nameValuePairs.add(new BasicNameValuePair("amount", amount));
        try {
            postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)postRequest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HttpEntity entity = response.getEntity();
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static GameAPI getInstance() {
        return instance;
    }

    public static class GameProfile {
        private int xp;
        private int coins;
        private boolean nick;
        private Player player;

        public GameProfile(Player p) {
            this.update(p);
        }

        public int getPlayerXp() {
            return this.xp;
        }

        public int getPlayerCoins() {
            return this.coins;
        }

        public boolean getPlayerNick() {
            return this.nick;
        }

        public void addPlayerXp(int xp) {
            GameAPI.addXp(this.player, xp);
        }

        public void addPlayerCoins(int coins) {
            GameAPI.addCoins(this.player, coins);
        }

        public void setPlayerNick(boolean nick) {
            GameAPI.setNick(this.player, nick);
        }

        public void update(Player p) {
            this.xp = GameAPI.getXp(p);
            this.coins = GameAPI.getCoins(p);
            String nick = GameAPI.getNick(p);
            this.nick = nick.contains("true") ? true : (nick.contains("false") ? false : false);
            this.player = p;
        }
    }
}

