/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.http.client;

import chat.giga.http.client.HttpClient;
import chat.giga.http.client.HttpClientException;
import chat.giga.http.client.HttpRequest;
import chat.giga.http.client.HttpResponse;
import chat.giga.http.client.JdkHttpClientBuilder;
import chat.giga.http.client.SSL;
import chat.giga.http.client.sse.SseListener;
import chat.giga.http.client.sse.SseParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JdkHttpClient
implements HttpClient {
    private final java.net.http.HttpClient delegate;
    private final Duration readTimeout;
    private final Map<String, String> customHeaders;

    public JdkHttpClient(JdkHttpClientBuilder builder) {
        HttpClient.Builder httpClientBuilder = builder.httpClientBuilder();
        if (builder.connectTimeout() != null) {
            httpClientBuilder.connectTimeout(builder.connectTimeout());
        }
        if (!(builder.ssl() == null || builder.ssl().verifySslCerts() && builder.ssl().keystorePath() == null && builder.ssl().truststorePath() == null)) {
            httpClientBuilder.sslContext(JdkHttpClient.createSSLContext(builder.ssl()));
        }
        this.customHeaders = builder.customHeaders() != null && !builder.customHeaders().isEmpty() ? builder.customHeaders() : Map.of();
        java.net.http.HttpClient baseClient = httpClientBuilder.build();
        this.delegate = builder.decorator() != null ? builder.decorator().apply(baseClient) : baseClient;
        this.readTimeout = builder.readTimeout();
    }

    public static JdkHttpClientBuilder builder() {
        return new JdkHttpClientBuilder();
    }

    private static HttpResponse mapResponse(java.net.http.HttpResponse<InputStream> jdkResponse) {
        HttpResponse httpResponse;
        block8: {
            InputStream body = jdkResponse.body();
            try {
                httpResponse = HttpResponse.builder().statusCode(jdkResponse.statusCode()).headers(jdkResponse.headers().map()).body(body.readAllBytes()).build();
                if (body == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            body.close();
        }
        return httpResponse;
    }

    public HttpResponse execute(HttpRequest request) {
        try {
            java.net.http.HttpResponse<InputStream> jdkResponse = this.delegate.send(this.mapJdkRequest(request), HttpResponse.BodyHandlers.ofInputStream());
            if (!JdkHttpClient.isSuccessful(jdkResponse)) {
                throw this.getClientException(jdkResponse);
            }
            return JdkHttpClient.mapResponse(jdkResponse);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpClientException getClientException(java.net.http.HttpResponse<InputStream> jdkResponse) {
        HttpClientException httpClientException;
        block8: {
            InputStream body = jdkResponse.body();
            try {
                httpClientException = new HttpClientException(jdkResponse.statusCode(), body.readAllBytes());
                if (body == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            body.close();
        }
        return httpClientException;
    }

    public void execute(HttpRequest request, SseListener listener) {
        java.net.http.HttpRequest jdkRequest = this.mapJdkRequest(request);
        SseParser parser = new SseParser(listener);
        try {
            java.net.http.HttpResponse<InputStream> jdkResponse = this.delegate.send(jdkRequest, HttpResponse.BodyHandlers.ofInputStream());
            if (!JdkHttpClient.isSuccessful(jdkResponse)) {
                listener.onError((Exception)this.getClientException(jdkResponse));
                return;
            }
            parser.parse(jdkResponse.body());
        }
        catch (Exception e) {
            listener.onError(e);
        }
    }

    public CompletableFuture<HttpResponse> executeAsync(HttpRequest request) {
        java.net.http.HttpRequest jdkRequest = this.mapJdkRequest(request);
        return this.delegate.sendAsync(jdkRequest, HttpResponse.BodyHandlers.ofInputStream()).thenApply(r -> {
            if (!JdkHttpClient.isSuccessful(r)) {
                throw this.getClientException((java.net.http.HttpResponse<InputStream>)r);
            }
            return JdkHttpClient.mapResponse(r);
        });
    }

    private static boolean isSuccessful(java.net.http.HttpResponse<InputStream> jdkResponse) {
        int statusCode = jdkResponse.statusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    private java.net.http.HttpRequest mapJdkRequest(HttpRequest request) {
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().uri(URI.create(request.url()));
        request.headers().forEach((name, values) -> {
            if (values != null) {
                values.forEach(value -> builder.header((String)name, (String)value));
            }
        });
        this.customHeaders.forEach((name, value) -> {
            if (value != null) {
                builder.header((String)name, (String)value);
            }
        });
        HttpRequest.BodyPublisher bodyPublisher = request.body() != null ? HttpRequest.BodyPublishers.ofByteArray(request.body()) : HttpRequest.BodyPublishers.noBody();
        builder.method(request.method().name(), bodyPublisher);
        if (this.readTimeout != null) {
            builder.timeout(this.readTimeout);
        }
        return builder.build();
    }

    private static TrustManager[] disableSSLVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
            return trustAllCerts;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SSLContext createSSLContext(SSL ssl) {
        try {
            KeyManager[] keyManagers = null;
            if (ssl.keystorePath() != null) {
                Objects.requireNonNull(ssl.keystorePassword(), "keystorePassword must not be null");
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance(ssl.keystoreType());
                try (FileInputStream keyStoreStream = new FileInputStream(ssl.keystorePath());){
                    keyStore.load(keyStoreStream, ssl.keystorePassword().toCharArray());
                }
                keyManagerFactory.init(keyStore, ssl.keystorePassword().toCharArray());
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            if (!ssl.verifySslCerts()) {
                trustManagers = JdkHttpClient.disableSSLVerification();
            } else if (ssl.truststorePath() != null) {
                Objects.requireNonNull(ssl.truststorePassword(), "truststorePassword must not be null");
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore trustStore = KeyStore.getInstance(ssl.trustStoreType());
                try (FileInputStream trustStoreStream = new FileInputStream(ssl.truststorePath());){
                    trustStore.load(trustStoreStream, ssl.truststorePassword().toCharArray());
                }
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            SSLContext sslContext = SSLContext.getInstance(ssl.protocol());
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

