/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.http.client;

import chat.giga.http.client.HttpClient;
import chat.giga.http.client.HttpRequest;
import chat.giga.http.client.HttpResponse;
import chat.giga.http.client.sse.SseListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHttpClient
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(LoggingHttpClient.class);
    private static final Set<String> SECRET_HEADERS = Set.of("authorization");
    private final HttpClient client;
    private final boolean logRequests;
    private final boolean logResponses;

    public LoggingHttpClient(HttpClient client, Boolean logRequests, Boolean logResponses) {
        this.client = client;
        this.logRequests = logRequests;
        this.logResponses = logResponses;
    }

    private void logRequest(HttpRequest httpRequest) {
        try {
            log.debug("HTTP request:\n- method: {}\n- url: {}\n- headers: {}\n- body: {}\n", new Object[]{httpRequest.method(), httpRequest.url(), this.format(httpRequest.headers()), this.isJsonBody(httpRequest.headers()) ? httpRequest.bodyAsString() : ""});
        }
        catch (Exception e) {
            log.error("Exception while logging HTTP request: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isJsonBody(Map<String, List<String>> headers) {
        return headers.entrySet().stream().filter(headerKey -> ((String)headerKey.getKey()).equalsIgnoreCase("Content-Type")).anyMatch(e -> ((List)e.getValue()).stream().anyMatch(ee -> ee.contains("application/json")));
    }

    private void logResponse(String responseDataPart) {
        try {
            log.debug("HTTP response_part\n- {}\n", (Object)responseDataPart);
        }
        catch (Exception e) {
            log.error("Exception while logging HTTP response: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void logResponse(HttpResponse response) {
        try {
            log.debug("HTTP response:\n- status code: {}\n- headers: {}\n- body: {}\n", new Object[]{response.statusCode(), this.format(response.headers()), this.isJsonBody(response.headers()) ? response.bodyAsString() : ""});
        }
        catch (Exception e) {
            log.error("Exception while logging HTTP response: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String format(Map<String, List<String>> headers) {
        return headers.entrySet().stream().filter(e -> !SECRET_HEADERS.contains(((String)e.getKey()).toLowerCase())).map(header -> String.format("[%s: %s]", header.getKey(), header.getValue())).collect(Collectors.joining(", "));
    }

    public HttpResponse execute(HttpRequest request) {
        if (this.logRequests) {
            this.logRequest(request);
        }
        HttpResponse response = this.client.execute(request);
        if (this.logResponses) {
            this.logResponse(response);
        }
        return response;
    }

    public void execute(HttpRequest request, final SseListener listener) {
        if (this.logRequests) {
            this.logRequest(request);
        }
        this.client.execute(request, new SseListener(){

            public void onData(String data) {
                if (LoggingHttpClient.this.logResponses) {
                    LoggingHttpClient.this.logResponse(data);
                }
                listener.onData(data);
            }

            public void onComplete() {
                listener.onComplete();
            }

            public void onError(Exception ex) {
                listener.onError(ex);
            }
        });
    }

    public CompletableFuture<HttpResponse> executeAsync(HttpRequest request) {
        if (this.logRequests) {
            this.logRequest(request);
        }
        CompletableFuture response = this.client.executeAsync(request);
        return response.thenApply(e -> {
            if (this.logResponses) {
                this.logResponse((HttpResponse)e);
            }
            return e;
        });
    }
}

