/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.http.client;

import chat.giga.http.client.HttpMethod;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class HttpRequest {
    private final HttpMethod method;
    private final String url;
    private final Map<String, List<String>> headers;
    private final byte[] body;

    public String bodyAsString() {
        if (this.body != null && this.body.length > 0) {
            return new String(this.body, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Generated
    HttpRequest(HttpMethod method, String url, Map<String, List<String>> headers, byte[] body) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
    }

    @Generated
    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    @Generated
    public HttpMethod method() {
        return this.method;
    }

    @Generated
    public String url() {
        return this.url;
    }

    @Generated
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Generated
    public byte[] body() {
        return this.body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        HttpMethod this$method = this.method();
        HttpMethod other$method = other.method();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.headers();
        Map<String, List<String>> other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        return Arrays.equals(this.body(), other.body());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMethod $method = this.method();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, List<String>> $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.body());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpRequest(method=" + String.valueOf((Object)this.method()) + ", url=" + this.url() + ", headers=" + String.valueOf(this.headers()) + ", body=" + Arrays.toString(this.body()) + ")";
    }

    public static class HttpRequestBuilder {
        @Generated
        private HttpMethod method;
        @Generated
        private String url;
        @Generated
        private byte[] body;
        Map<String, List<String>> headers = new HashMap<String, List<String>>();

        public HttpRequestBuilder header(String name, String value) {
            this.headers.computeIfAbsent(name, k -> new ArrayList(1)).add(value);
            return this;
        }

        public HttpRequestBuilder headerIf(boolean condition, String name, String value) {
            if (condition) {
                this.header(name, value);
            }
            return this;
        }

        @Generated
        HttpRequestBuilder() {
        }

        @Generated
        public HttpRequestBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @Generated
        public HttpRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public HttpRequestBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public HttpRequestBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        @Generated
        public HttpRequest build() {
            return new HttpRequest(this.method, this.url, this.headers, this.body);
        }

        @Generated
        public String toString() {
            return "HttpRequest.HttpRequestBuilder(method=" + String.valueOf((Object)this.method) + ", url=" + this.url + ", headers=" + String.valueOf(this.headers) + ", body=" + Arrays.toString(this.body) + ")";
        }
    }
}

