/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.http.client.sse;

import chat.giga.http.client.sse.SseListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;

public class SseParser {
    private final SseListener listener;

    public void parse(InputStream body) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(body));){
            AtomicBoolean done = new AtomicBoolean(false);
            reader.lines().forEach(l -> {
                if (done.get()) {
                    return;
                }
                String[] data = l.split(": ");
                if ("data".equals(data[0])) {
                    if ("[DONE]".equals(data[1])) {
                        done.set(true);
                        this.listener.onComplete();
                        return;
                    }
                    this.listener.onData(data[1]);
                }
            });
        }
        catch (Exception e) {
            this.listener.onError(e);
        }
    }

    @Generated
    public SseParser(SseListener listener) {
        this.listener = listener;
    }
}

