/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.client;

import chat.giga.client.auth.AuthClient;
import chat.giga.http.client.HttpClient;
import chat.giga.http.client.HttpMethod;
import chat.giga.http.client.HttpRequest;
import chat.giga.http.client.JdkHttpClientBuilder;
import chat.giga.http.client.LoggingHttpClient;
import chat.giga.http.client.SSL;
import chat.giga.model.TokenCountRequest;
import chat.giga.model.completion.CompletionRequest;
import chat.giga.model.embedding.EmbeddingRequest;
import chat.giga.model.file.UploadFileRequest;
import chat.giga.util.FileUtils;
import chat.giga.util.JsonUtils;
import chat.giga.util.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;

abstract class BaseGigaChatClient {
    public static final String DEFAULT_API_URL = "https://gigachat.devices.sberbank.ru/api/v1";
    public static final String REQUEST_ID_HEADER = "X-Request-ID";
    public static final String CLIENT_ID_HEADER = "X-Client-ID";
    public static final String SESSION_ID_HEADER = "X-Session-ID";
    public static final String USER_AGENT_NAME = "GigaChat-java-lib";
    public static final int MAX_RETRIES = 1;
    protected final int maxRetriesOnAuthError;
    protected final AuthClient authClient;
    protected final HttpClient httpClient;
    protected final String apiUrl;
    protected final ObjectMapper objectMapper = JsonUtils.objectMapper();

    protected BaseGigaChatClient(HttpClient apiHttpClient, AuthClient authClient, Integer readTimeout, Integer connectTimeout, String apiUrl, boolean logRequests, boolean logResponses, boolean verifySslCerts, Integer maxRetriesOnAuthError) {
        Objects.requireNonNull(authClient, "authClient must not be null");
        this.apiUrl = Utils.getOrDefault(apiUrl, DEFAULT_API_URL);
        this.authClient = authClient;
        this.maxRetriesOnAuthError = Utils.getOrDefault(maxRetriesOnAuthError, 1);
        HttpClient client = authClient.supportsHttpClient() ? authClient.getHttpClient() : (apiHttpClient == null ? new JdkHttpClientBuilder().readTimeout(Duration.ofSeconds(Utils.getOrDefault(readTimeout, 15).intValue())).connectTimeout(Duration.ofSeconds(Utils.getOrDefault(connectTimeout, 15).intValue())).ssl(this.mapSslConfig(verifySslCerts)).build() : apiHttpClient);
        this.httpClient = logRequests || logResponses ? new LoggingHttpClient(client, Boolean.valueOf(logRequests), Boolean.valueOf(logResponses)) : client;
    }

    protected HttpRequest createModelHttpRequest() {
        HttpRequest.HttpRequestBuilder builder = HttpRequest.builder().url(this.apiUrl + "/models").method(HttpMethod.GET).header("User-Agent", USER_AGENT_NAME).header("Accept", "application/json").header(REQUEST_ID_HEADER, UUID.randomUUID().toString());
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createCompletionHttpRequest(CompletionRequest request, String sessionId) {
        HttpRequest.HttpRequestBuilder builder;
        try {
            builder = HttpRequest.builder().url(this.apiUrl + "/chat/completions").method(HttpMethod.POST).header("User-Agent", USER_AGENT_NAME).header("Content-Type", "application/json").header("Accept", "application/json").header(REQUEST_ID_HEADER, UUID.randomUUID().toString()).headerIf(sessionId != null, SESSION_ID_HEADER, sessionId).body(this.objectMapper.writeValueAsBytes((Object)request.toBuilder().stream(false).build()));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createEmbendingHttpRequest(EmbeddingRequest request) {
        HttpRequest.HttpRequestBuilder builder;
        try {
            builder = HttpRequest.builder().url(this.apiUrl + "/embeddings").method(HttpMethod.POST).header("User-Agent", USER_AGENT_NAME).header("Content-Type", "application/json").header("Accept", "application/json").header(REQUEST_ID_HEADER, UUID.randomUUID().toString()).body(this.objectMapper.writeValueAsBytes((Object)request));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createUploadFileHttpRequest(UploadFileRequest request) {
        String boundary = Long.toHexString(System.currentTimeMillis());
        StringBuilder requestBody = FileUtils.createMultiPartBody(request.file(), boundary, request.purpose(), request.mimeType(), request.fileName());
        HttpRequest.HttpRequestBuilder builder = HttpRequest.builder().url(this.apiUrl + "/files").method(HttpMethod.POST).header("User-Agent", USER_AGENT_NAME).header("Content-Type", "multipart/form-data; boundary=" + boundary).header("Accept", "application/json").body(requestBody.toString().getBytes(StandardCharsets.UTF_8));
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createDownloadFileHttpRequest(String fileId, String clientId) {
        HttpRequest.HttpRequestBuilder builder = HttpRequest.builder().url(this.apiUrl + "/files/" + fileId + "/content").method(HttpMethod.GET).header("User-Agent", USER_AGENT_NAME).header("Accept", "application/octet-stream").headerIf(clientId != null, CLIENT_ID_HEADER, clientId);
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createListAvailableFileHttpRequest() {
        HttpRequest.HttpRequestBuilder builder = HttpRequest.builder().url(this.apiUrl + "/files").method(HttpMethod.GET).header("User-Agent", USER_AGENT_NAME).header("Accept", "application/json");
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createFileInfoHttpRequest(String fileId) {
        HttpRequest.HttpRequestBuilder builder = HttpRequest.builder().url(this.apiUrl + "/files/" + fileId).method(HttpMethod.GET).header("User-Agent", USER_AGENT_NAME).header("Accept", "application/json");
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createDeleteFileHttpRequest(String fileId) {
        HttpRequest.HttpRequestBuilder builder = HttpRequest.builder().url(this.apiUrl + "/files/" + fileId + "/delete").method(HttpMethod.POST).header("User-Agent", USER_AGENT_NAME).header("Accept", "application/json");
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createTokenCountHttpRequest(TokenCountRequest request) {
        HttpRequest.HttpRequestBuilder builder;
        try {
            builder = HttpRequest.builder().url(this.apiUrl + "/tokens/count").method(HttpMethod.POST).header("User-Agent", USER_AGENT_NAME).header("Content-Type", "application/json").header("Accept", "application/json").header(REQUEST_ID_HEADER, UUID.randomUUID().toString()).body(this.objectMapper.writeValueAsBytes((Object)request));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.authClient.authenticate(builder);
        return builder.build();
    }

    protected HttpRequest createBalanceHttpRequest() {
        HttpRequest.HttpRequestBuilder builder = HttpRequest.builder().url(this.apiUrl + "/balance").method(HttpMethod.GET).header("User-Agent", USER_AGENT_NAME).header("Accept", "application/json").header(REQUEST_ID_HEADER, UUID.randomUUID().toString());
        this.authClient.authenticate(builder);
        return builder.build();
    }

    private SSL mapSslConfig(boolean verifySslCerts) {
        if (!verifySslCerts) {
            return SSL.builder().verifySslCerts(false).build();
        }
        return null;
    }
}

