/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.client;

import chat.giga.client.BaseGigaChatClient;
import chat.giga.client.GigaChatClientAsync;
import chat.giga.client.ResponseHandler;
import chat.giga.client.auth.AuthClient;
import chat.giga.http.client.HttpClient;
import chat.giga.http.client.HttpClientException;
import chat.giga.http.client.HttpMethod;
import chat.giga.http.client.HttpRequest;
import chat.giga.http.client.sse.SseListener;
import chat.giga.model.BalanceResponse;
import chat.giga.model.ModelResponse;
import chat.giga.model.TokenCount;
import chat.giga.model.TokenCountRequest;
import chat.giga.model.completion.CompletionChunkResponse;
import chat.giga.model.completion.CompletionRequest;
import chat.giga.model.completion.CompletionResponse;
import chat.giga.model.embedding.EmbeddingRequest;
import chat.giga.model.embedding.EmbeddingResponse;
import chat.giga.model.file.AvailableFilesResponse;
import chat.giga.model.file.FileDeletedResponse;
import chat.giga.model.file.FileResponse;
import chat.giga.model.file.UploadFileRequest;
import chat.giga.util.RetryUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class GigaChatClientAsyncImpl
extends BaseGigaChatClient
implements GigaChatClientAsync {
    GigaChatClientAsyncImpl(HttpClient apiHttpClient, AuthClient authClient, Integer readTimeout, Integer connectTimeout, String apiUrl, boolean logRequests, boolean logResponses, boolean verifySslCerts, Integer maxRetriesOnAuthError) {
        super(apiHttpClient, authClient, readTimeout, connectTimeout, apiUrl, logRequests, logResponses, verifySslCerts, maxRetriesOnAuthError);
    }

    @Override
    public CompletableFuture<ModelResponse> models() {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createModelHttpRequest()).thenApply(r -> {
            try {
                return (ModelResponse)this.objectMapper.readValue(r.body(), ModelResponse.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Override
    public CompletableFuture<CompletionResponse> completions(CompletionRequest request, String sessionId) {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createCompletionHttpRequest(request, sessionId)).thenApply(r -> {
            try {
                return (CompletionResponse)this.objectMapper.readValue(r.body(), CompletionResponse.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Override
    public void completions(CompletionRequest request, final ResponseHandler<CompletionChunkResponse> handler) {
        try {
            HttpRequest.HttpRequestBuilder builder = HttpRequest.builder().url(this.apiUrl + "/chat/completions").method(HttpMethod.POST).header("User-Agent", "GigaChat-java-lib").header("Content-Type", "application/json").header("Accept", "text/event-stream").header("X-Request-ID", UUID.randomUUID().toString()).body(this.objectMapper.writeValueAsBytes((Object)request.toBuilder().stream(true).build()));
            CompletableFuture.runAsync(() -> {
                try {
                    RetryUtils.retry401(() -> {
                        this.authClient.authenticate(builder);
                        this.httpClient.execute(builder.build(), new SseListener(){

                            public void onData(String data) {
                                try {
                                    handler.onNext((CompletionChunkResponse)GigaChatClientAsyncImpl.this.objectMapper.readValue(data, CompletionChunkResponse.class));
                                }
                                catch (IOException e) {
                                    handler.onError(e);
                                }
                            }

                            public void onComplete() {
                                handler.onComplete();
                            }

                            public void onError(Exception ex) {
                                HttpClientException e;
                                if (ex instanceof HttpClientException && (e = (HttpClientException)((Object)ex)).statusCode() == 401) {
                                    throw e;
                                }
                                handler.onError(ex);
                            }
                        });
                        return null;
                    }, this.maxRetriesOnAuthError);
                }
                catch (IllegalStateException e) {
                    handler.onError(e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public CompletableFuture<EmbeddingResponse> embeddings(EmbeddingRequest request) {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createEmbendingHttpRequest(request)).thenApply(r -> {
            try {
                return (EmbeddingResponse)this.objectMapper.readValue(r.body(), EmbeddingResponse.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Override
    public CompletableFuture<FileResponse> uploadFile(UploadFileRequest request) {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createUploadFileHttpRequest(request)).thenApply(r -> {
            try {
                return (FileResponse)this.objectMapper.readValue(r.body(), FileResponse.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Override
    public CompletableFuture<ByteArrayInputStream> downloadFile(String fileId, String clientId) {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createDownloadFileHttpRequest(fileId, clientId)).thenApply(r -> new ByteArrayInputStream(r.body())), 1);
    }

    @Override
    public CompletableFuture<AvailableFilesResponse> getListAvailableFile() {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createListAvailableFileHttpRequest()).thenApply(r -> {
            try {
                return (AvailableFilesResponse)this.objectMapper.readValue(r.body(), AvailableFilesResponse.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Override
    public CompletableFuture<FileResponse> getFileInfo(String fileId) {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createFileInfoHttpRequest(fileId)).thenApply(r -> {
            try {
                return (FileResponse)this.objectMapper.readValue(r.body(), FileResponse.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Override
    public CompletableFuture<FileDeletedResponse> deleteFile(String fileId) {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createDeleteFileHttpRequest(fileId)).thenApply(r -> {
            try {
                return (FileDeletedResponse)this.objectMapper.readValue(r.body(), FileDeletedResponse.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Override
    public CompletableFuture<List<TokenCount>> tokensCount(TokenCountRequest request) {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createTokenCountHttpRequest(request)).thenApply(r -> {
            try {
                return (List)this.objectMapper.readValue(r.body(), (TypeReference)new TypeReference<List<TokenCount>>(){});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Override
    public CompletableFuture<BalanceResponse> balance() {
        return RetryUtils.retry401Async(() -> this.httpClient.executeAsync(this.createBalanceHttpRequest()).thenApply(r -> {
            try {
                return (BalanceResponse)this.objectMapper.readValue(r.body(), BalanceResponse.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), this.maxRetriesOnAuthError);
    }

    @Generated
    public static GigaChatClientAsyncImplBuilder builder() {
        return new GigaChatClientAsyncImplBuilder();
    }

    @Generated
    public static class GigaChatClientAsyncImplBuilder {
        @Generated
        private HttpClient apiHttpClient;
        @Generated
        private AuthClient authClient;
        @Generated
        private Integer readTimeout;
        @Generated
        private Integer connectTimeout;
        @Generated
        private String apiUrl;
        @Generated
        private boolean logRequests;
        @Generated
        private boolean logResponses;
        @Generated
        private boolean verifySslCerts;
        @Generated
        private Integer maxRetriesOnAuthError;

        @Generated
        GigaChatClientAsyncImplBuilder() {
        }

        @Generated
        public GigaChatClientAsyncImplBuilder apiHttpClient(HttpClient apiHttpClient) {
            this.apiHttpClient = apiHttpClient;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImplBuilder authClient(AuthClient authClient) {
            this.authClient = authClient;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImplBuilder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImplBuilder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImplBuilder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImplBuilder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImplBuilder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImplBuilder verifySslCerts(boolean verifySslCerts) {
            this.verifySslCerts = verifySslCerts;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImplBuilder maxRetriesOnAuthError(Integer maxRetriesOnAuthError) {
            this.maxRetriesOnAuthError = maxRetriesOnAuthError;
            return this;
        }

        @Generated
        public GigaChatClientAsyncImpl build() {
            return new GigaChatClientAsyncImpl(this.apiHttpClient, this.authClient, this.readTimeout, this.connectTimeout, this.apiUrl, this.logRequests, this.logResponses, this.verifySslCerts, this.maxRetriesOnAuthError);
        }

        @Generated
        public String toString() {
            return "GigaChatClientAsyncImpl.GigaChatClientAsyncImplBuilder(apiHttpClient=" + String.valueOf(this.apiHttpClient) + ", authClient=" + String.valueOf(this.authClient) + ", readTimeout=" + this.readTimeout + ", connectTimeout=" + this.connectTimeout + ", apiUrl=" + this.apiUrl + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", verifySslCerts=" + this.verifySslCerts + ", maxRetriesOnAuthError=" + this.maxRetriesOnAuthError + ")";
        }
    }
}

