/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.client;

import chat.giga.client.BaseGigaChatClient;
import chat.giga.client.GigaChatClient;
import chat.giga.client.auth.AuthClient;
import chat.giga.http.client.HttpClient;
import chat.giga.http.client.HttpResponse;
import chat.giga.model.BalanceResponse;
import chat.giga.model.ModelResponse;
import chat.giga.model.TokenCount;
import chat.giga.model.TokenCountRequest;
import chat.giga.model.completion.CompletionRequest;
import chat.giga.model.completion.CompletionResponse;
import chat.giga.model.embedding.EmbeddingRequest;
import chat.giga.model.embedding.EmbeddingResponse;
import chat.giga.model.file.AvailableFilesResponse;
import chat.giga.model.file.FileDeletedResponse;
import chat.giga.model.file.FileResponse;
import chat.giga.model.file.UploadFileRequest;
import chat.giga.util.RetryUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import lombok.Generated;

public class GigaChatClientImpl
extends BaseGigaChatClient
implements GigaChatClient {
    GigaChatClientImpl(HttpClient apiHttpClient, AuthClient authClient, Integer readTimeout, Integer connectTimeout, String apiUrl, boolean logRequests, boolean logResponses, boolean verifySslCerts, Integer maxRetriesOnAuthError) {
        super(apiHttpClient, authClient, readTimeout, connectTimeout, apiUrl, logRequests, logResponses, verifySslCerts, maxRetriesOnAuthError);
    }

    @Override
    public ModelResponse models() {
        HttpResponse httpResponse = RetryUtils.retry401(() -> this.httpClient.execute(this.createModelHttpRequest()), this.maxRetriesOnAuthError);
        try {
            return (ModelResponse)this.objectMapper.readValue(httpResponse.body(), ModelResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public CompletionResponse completions(CompletionRequest request, String sessionId) {
        try {
            HttpResponse httpResponse = RetryUtils.retry401(() -> this.httpClient.execute(this.createCompletionHttpRequest(request, sessionId)), this.maxRetriesOnAuthError);
            return (CompletionResponse)this.objectMapper.readValue(httpResponse.body(), CompletionResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public EmbeddingResponse embeddings(EmbeddingRequest request) {
        try {
            HttpResponse httpResponse = RetryUtils.retry401(() -> this.httpClient.execute(this.createEmbendingHttpRequest(request)), this.maxRetriesOnAuthError);
            return (EmbeddingResponse)this.objectMapper.readValue(httpResponse.body(), EmbeddingResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public FileResponse uploadFile(UploadFileRequest request) {
        HttpResponse response = RetryUtils.retry401(() -> this.httpClient.execute(this.createUploadFileHttpRequest(request)), this.maxRetriesOnAuthError);
        try {
            return (FileResponse)this.objectMapper.readValue(response.body(), FileResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public byte[] downloadFile(String fileId, String clientId) {
        return RetryUtils.retry401(() -> this.httpClient.execute(this.createDownloadFileHttpRequest(fileId, clientId)), this.maxRetriesOnAuthError).body();
    }

    @Override
    public AvailableFilesResponse getListAvailableFile() {
        HttpResponse httpResponse = RetryUtils.retry401(() -> this.httpClient.execute(this.createListAvailableFileHttpRequest()), this.maxRetriesOnAuthError);
        try {
            return (AvailableFilesResponse)this.objectMapper.readValue(httpResponse.body(), AvailableFilesResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public FileResponse getFileInfo(String fileId) {
        HttpResponse response = RetryUtils.retry401(() -> this.httpClient.execute(this.createFileInfoHttpRequest(fileId)), this.maxRetriesOnAuthError);
        try {
            return (FileResponse)this.objectMapper.readValue(response.body(), FileResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public FileDeletedResponse deleteFile(String fileId) {
        HttpResponse response = RetryUtils.retry401(() -> this.httpClient.execute(this.createDeleteFileHttpRequest(fileId)), this.maxRetriesOnAuthError);
        try {
            return (FileDeletedResponse)this.objectMapper.readValue(response.body(), FileDeletedResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public List<TokenCount> tokensCount(TokenCountRequest request) {
        HttpResponse httpResponse = RetryUtils.retry401(() -> this.httpClient.execute(this.createTokenCountHttpRequest(request)), this.maxRetriesOnAuthError);
        try {
            return (List)this.objectMapper.readValue(httpResponse.body(), (TypeReference)new TypeReference<List<TokenCount>>(){});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public BalanceResponse balance() {
        HttpResponse httpResponse = RetryUtils.retry401(() -> this.httpClient.execute(this.createBalanceHttpRequest()), this.maxRetriesOnAuthError);
        try {
            return (BalanceResponse)this.objectMapper.readValue(httpResponse.body(), BalanceResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    public static GigaChatClientImplBuilder builder() {
        return new GigaChatClientImplBuilder();
    }

    @Generated
    public static class GigaChatClientImplBuilder {
        @Generated
        private HttpClient apiHttpClient;
        @Generated
        private AuthClient authClient;
        @Generated
        private Integer readTimeout;
        @Generated
        private Integer connectTimeout;
        @Generated
        private String apiUrl;
        @Generated
        private boolean logRequests;
        @Generated
        private boolean logResponses;
        @Generated
        private boolean verifySslCerts;
        @Generated
        private Integer maxRetriesOnAuthError;

        @Generated
        GigaChatClientImplBuilder() {
        }

        @Generated
        public GigaChatClientImplBuilder apiHttpClient(HttpClient apiHttpClient) {
            this.apiHttpClient = apiHttpClient;
            return this;
        }

        @Generated
        public GigaChatClientImplBuilder authClient(AuthClient authClient) {
            this.authClient = authClient;
            return this;
        }

        @Generated
        public GigaChatClientImplBuilder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Generated
        public GigaChatClientImplBuilder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Generated
        public GigaChatClientImplBuilder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        @Generated
        public GigaChatClientImplBuilder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        @Generated
        public GigaChatClientImplBuilder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        @Generated
        public GigaChatClientImplBuilder verifySslCerts(boolean verifySslCerts) {
            this.verifySslCerts = verifySslCerts;
            return this;
        }

        @Generated
        public GigaChatClientImplBuilder maxRetriesOnAuthError(Integer maxRetriesOnAuthError) {
            this.maxRetriesOnAuthError = maxRetriesOnAuthError;
            return this;
        }

        @Generated
        public GigaChatClientImpl build() {
            return new GigaChatClientImpl(this.apiHttpClient, this.authClient, this.readTimeout, this.connectTimeout, this.apiUrl, this.logRequests, this.logResponses, this.verifySslCerts, this.maxRetriesOnAuthError);
        }

        @Generated
        public String toString() {
            return "GigaChatClientImpl.GigaChatClientImplBuilder(apiHttpClient=" + String.valueOf(this.apiHttpClient) + ", authClient=" + String.valueOf(this.authClient) + ", readTimeout=" + this.readTimeout + ", connectTimeout=" + this.connectTimeout + ", apiUrl=" + this.apiUrl + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", verifySslCerts=" + this.verifySslCerts + ", maxRetriesOnAuthError=" + this.maxRetriesOnAuthError + ")";
        }
    }
}

