/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.client.auth;

import chat.giga.client.auth.AuthClient;
import chat.giga.client.auth.CertificateAuthClient;
import chat.giga.client.auth.OAuthClient;
import chat.giga.client.auth.ProvidedTokenAuthClient;
import chat.giga.client.auth.UserPasswordAuthClient;
import chat.giga.http.client.HttpClient;
import chat.giga.http.client.JdkHttpClientBuilder;
import chat.giga.http.client.SSL;
import chat.giga.model.Scope;
import chat.giga.util.Utils;
import java.time.Duration;
import lombok.Generated;

public class AuthClientBuilder {
    private AuthClient method;

    public static AuthClientBuilder builder() {
        return new AuthClientBuilder();
    }

    public AuthClientBuilder withOAuth(OAuthBuilder builder) {
        this.method = new OAuthClient(builder.httpClient == null ? new JdkHttpClientBuilder().readTimeout(Duration.ofSeconds(Utils.getOrDefault(builder.readTimeout, 15).intValue())).connectTimeout(Duration.ofSeconds(Utils.getOrDefault(builder.connectTimeout, 15).intValue())).ssl(this.mapSslConfig(builder.verifySslCerts)).build() : builder.httpClient, builder.clientId, builder.clientSecret, builder.authKey, builder.scope, builder.authApiUrl);
        return this;
    }

    public AuthClientBuilder withUserPassword(UserPasswordAuthBuilder builder) {
        this.method = new UserPasswordAuthClient(builder.httpClient == null ? new JdkHttpClientBuilder().readTimeout(Duration.ofSeconds(Utils.getOrDefault(builder.readTimeout, 15).intValue())).connectTimeout(Duration.ofSeconds(Utils.getOrDefault(builder.connectTimeout, 15).intValue())).ssl(this.mapSslConfig(builder.verifySslCerts)).build() : builder.httpClient, builder.user, builder.password, builder.scope, builder.authApiUrl);
        return this;
    }

    public AuthClientBuilder withProvidedTokenAuth(String accessToken) {
        this.method = new ProvidedTokenAuthClient(accessToken);
        return this;
    }

    public AuthClientBuilder withCertificatesAuth(HttpClient httpClient) {
        this.method = new CertificateAuthClient(httpClient);
        return this;
    }

    public AuthClient build() {
        if (this.method == null) {
            throw new IllegalStateException("Authentication method not specified");
        }
        return this.method;
    }

    private SSL mapSslConfig(boolean verifySslCerts) {
        if (!verifySslCerts) {
            return SSL.builder().verifySslCerts(false).build();
        }
        return null;
    }

    public static class OAuthBuilder {
        private String clientId;
        private String clientSecret;
        private String authKey;
        private HttpClient httpClient;
        private Integer readTimeout;
        private Integer connectTimeout;
        private Scope scope;
        private String authApiUrl;
        private boolean verifySslCerts;

        @Generated
        OAuthBuilder(String clientId, String clientSecret, String authKey, HttpClient httpClient, Integer readTimeout, Integer connectTimeout, Scope scope, String authApiUrl, boolean verifySslCerts) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.authKey = authKey;
            this.httpClient = httpClient;
            this.readTimeout = readTimeout;
            this.connectTimeout = connectTimeout;
            this.scope = scope;
            this.authApiUrl = authApiUrl;
            this.verifySslCerts = verifySslCerts;
        }

        @Generated
        public static OAuthBuilderBuilder builder() {
            return new OAuthBuilderBuilder();
        }

        @Generated
        public static class OAuthBuilderBuilder {
            @Generated
            private String clientId;
            @Generated
            private String clientSecret;
            @Generated
            private String authKey;
            @Generated
            private HttpClient httpClient;
            @Generated
            private Integer readTimeout;
            @Generated
            private Integer connectTimeout;
            @Generated
            private Scope scope;
            @Generated
            private String authApiUrl;
            @Generated
            private boolean verifySslCerts;

            @Generated
            OAuthBuilderBuilder() {
            }

            @Generated
            public OAuthBuilderBuilder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            @Generated
            public OAuthBuilderBuilder clientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            @Generated
            public OAuthBuilderBuilder authKey(String authKey) {
                this.authKey = authKey;
                return this;
            }

            @Generated
            public OAuthBuilderBuilder httpClient(HttpClient httpClient) {
                this.httpClient = httpClient;
                return this;
            }

            @Generated
            public OAuthBuilderBuilder readTimeout(Integer readTimeout) {
                this.readTimeout = readTimeout;
                return this;
            }

            @Generated
            public OAuthBuilderBuilder connectTimeout(Integer connectTimeout) {
                this.connectTimeout = connectTimeout;
                return this;
            }

            @Generated
            public OAuthBuilderBuilder scope(Scope scope) {
                this.scope = scope;
                return this;
            }

            @Generated
            public OAuthBuilderBuilder authApiUrl(String authApiUrl) {
                this.authApiUrl = authApiUrl;
                return this;
            }

            @Generated
            public OAuthBuilderBuilder verifySslCerts(boolean verifySslCerts) {
                this.verifySslCerts = verifySslCerts;
                return this;
            }

            @Generated
            public OAuthBuilder build() {
                return new OAuthBuilder(this.clientId, this.clientSecret, this.authKey, this.httpClient, this.readTimeout, this.connectTimeout, this.scope, this.authApiUrl, this.verifySslCerts);
            }

            @Generated
            public String toString() {
                return "AuthClientBuilder.OAuthBuilder.OAuthBuilderBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", authKey=" + this.authKey + ", httpClient=" + String.valueOf(this.httpClient) + ", readTimeout=" + this.readTimeout + ", connectTimeout=" + this.connectTimeout + ", scope=" + String.valueOf((Object)this.scope) + ", authApiUrl=" + this.authApiUrl + ", verifySslCerts=" + this.verifySslCerts + ")";
            }
        }
    }

    public static class UserPasswordAuthBuilder {
        private String user;
        private String password;
        private HttpClient httpClient;
        private Integer readTimeout;
        private Integer connectTimeout;
        private Scope scope;
        private String authApiUrl;
        private boolean verifySslCerts;

        @Generated
        UserPasswordAuthBuilder(String user, String password, HttpClient httpClient, Integer readTimeout, Integer connectTimeout, Scope scope, String authApiUrl, boolean verifySslCerts) {
            this.user = user;
            this.password = password;
            this.httpClient = httpClient;
            this.readTimeout = readTimeout;
            this.connectTimeout = connectTimeout;
            this.scope = scope;
            this.authApiUrl = authApiUrl;
            this.verifySslCerts = verifySslCerts;
        }

        @Generated
        public static UserPasswordAuthBuilderBuilder builder() {
            return new UserPasswordAuthBuilderBuilder();
        }

        @Generated
        public static class UserPasswordAuthBuilderBuilder {
            @Generated
            private String user;
            @Generated
            private String password;
            @Generated
            private HttpClient httpClient;
            @Generated
            private Integer readTimeout;
            @Generated
            private Integer connectTimeout;
            @Generated
            private Scope scope;
            @Generated
            private String authApiUrl;
            @Generated
            private boolean verifySslCerts;

            @Generated
            UserPasswordAuthBuilderBuilder() {
            }

            @Generated
            public UserPasswordAuthBuilderBuilder user(String user) {
                this.user = user;
                return this;
            }

            @Generated
            public UserPasswordAuthBuilderBuilder password(String password) {
                this.password = password;
                return this;
            }

            @Generated
            public UserPasswordAuthBuilderBuilder httpClient(HttpClient httpClient) {
                this.httpClient = httpClient;
                return this;
            }

            @Generated
            public UserPasswordAuthBuilderBuilder readTimeout(Integer readTimeout) {
                this.readTimeout = readTimeout;
                return this;
            }

            @Generated
            public UserPasswordAuthBuilderBuilder connectTimeout(Integer connectTimeout) {
                this.connectTimeout = connectTimeout;
                return this;
            }

            @Generated
            public UserPasswordAuthBuilderBuilder scope(Scope scope) {
                this.scope = scope;
                return this;
            }

            @Generated
            public UserPasswordAuthBuilderBuilder authApiUrl(String authApiUrl) {
                this.authApiUrl = authApiUrl;
                return this;
            }

            @Generated
            public UserPasswordAuthBuilderBuilder verifySslCerts(boolean verifySslCerts) {
                this.verifySslCerts = verifySslCerts;
                return this;
            }

            @Generated
            public UserPasswordAuthBuilder build() {
                return new UserPasswordAuthBuilder(this.user, this.password, this.httpClient, this.readTimeout, this.connectTimeout, this.scope, this.authApiUrl, this.verifySslCerts);
            }

            @Generated
            public String toString() {
                return "AuthClientBuilder.UserPasswordAuthBuilder.UserPasswordAuthBuilderBuilder(user=" + this.user + ", password=" + this.password + ", httpClient=" + String.valueOf(this.httpClient) + ", readTimeout=" + this.readTimeout + ", connectTimeout=" + this.connectTimeout + ", scope=" + String.valueOf((Object)this.scope) + ", authApiUrl=" + this.authApiUrl + ", verifySslCerts=" + this.verifySslCerts + ")";
            }
        }
    }
}

