/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.client.auth;

import chat.giga.client.auth.AccessToken;
import chat.giga.client.auth.AuthClient;
import chat.giga.client.auth.TokenBasedAuthClient;
import chat.giga.http.client.HttpClient;
import chat.giga.http.client.HttpRequest;
import chat.giga.http.client.HttpResponse;
import chat.giga.model.AccessTokenResponse;
import chat.giga.model.Scope;
import chat.giga.util.Utils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

class OAuthClient
extends TokenBasedAuthClient
implements AuthClient {
    public static final String RQ_UID_HEADER = "RqUID";
    private static final String DEFAULT_AUTH_URL = "https://ngw.devices.sberbank.ru:9443/api/v2";
    private final String clientId;
    private final String secret;
    private final String authKey;
    private final Scope scope;
    private final HttpClient httpClient;
    private final String authApiUrl;

    public OAuthClient(HttpClient httpClient, String clientId, String secret, String authKey, Scope scope, String authApiUrl) {
        this.httpClient = httpClient;
        this.clientId = clientId;
        this.secret = secret;
        this.authKey = authKey;
        this.scope = scope;
        this.authApiUrl = Utils.getOrDefault(authApiUrl, DEFAULT_AUTH_URL);
        this.validateParams();
    }

    private void validateParams() {
        if (this.authKey == null) {
            Objects.requireNonNull(this.clientId, "clientId must not be null");
            Objects.requireNonNull(this.secret, "clientSecret must not be null");
        }
        Objects.requireNonNull(this.scope, "scope must not be null");
    }

    @Override
    public boolean supportsHttpClient() {
        return false;
    }

    @Override
    public void authenticate(HttpRequest.HttpRequestBuilder requestBuilder) {
        requestBuilder.header("Authorization", this.getBearerAuth());
    }

    @Override
    public HttpClient getHttpClient() {
        return null;
    }

    public AccessTokenResponse oauth() {
        HttpRequest httpRequest = (this.authKey == null ? this.getTokenRequest(this.authApiUrl + "/oauth", this.scope, this.clientId, this.secret) : this.getTokenRequest(this.authApiUrl + "/oauth", this.scope, this.authKey)).header(RQ_UID_HEADER, UUID.randomUUID().toString()).build();
        try {
            HttpResponse httpResponse = this.httpClient.execute(httpRequest);
            return (AccessTokenResponse)this.objectMapper.readValue(httpResponse.body(), AccessTokenResponse.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public AccessToken getToken() {
        AccessTokenResponse token = this.oauth();
        return new AccessToken(token.accessToken(), Instant.ofEpochMilli(token.expiresAt()));
    }
}

