/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.client.auth;

import chat.giga.client.auth.AccessToken;
import chat.giga.client.auth.AuthClient;
import chat.giga.http.client.HttpClient;
import chat.giga.http.client.HttpRequest;
import java.util.Objects;

class ProvidedTokenAuthClient
implements AuthClient {
    private final String accessToken;

    public ProvidedTokenAuthClient(String accessToken) {
        Objects.requireNonNull(accessToken, "accessToken must not be null");
        this.accessToken = accessToken;
    }

    @Override
    public boolean supportsHttpClient() {
        return false;
    }

    @Override
    public void authenticate(HttpRequest.HttpRequestBuilder requestBuilder) {
        requestBuilder.header("Authorization", "Bearer " + this.accessToken);
    }

    @Override
    public HttpClient getHttpClient() {
        return null;
    }

    @Override
    public AccessToken getToken() {
        return new AccessToken(this.accessToken, null);
    }
}

