/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.client.auth;

import chat.giga.client.auth.AccessToken;
import chat.giga.http.client.HttpMethod;
import chat.giga.http.client.HttpRequest;
import chat.giga.model.Scope;
import chat.giga.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;

abstract class TokenBasedAuthClient {
    public static final String USER_AGENT_NAME = "GigaChat-java-lib";
    protected final ObjectMapper objectMapper = JsonUtils.objectMapper();
    private final AtomicReference<AccessToken> accessToken = new AtomicReference();

    TokenBasedAuthClient() {
    }

    protected HttpRequest.HttpRequestBuilder getTokenRequest(String url, Scope scope, String user, String password) {
        String credentials = user + ":" + password;
        String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
        return this.getTokenRequest(url, scope, encodedCredentials);
    }

    protected HttpRequest.HttpRequestBuilder getTokenRequest(String url, Scope scope, String key) {
        String formData = "scope=" + scope.name();
        return HttpRequest.builder().url(url).method(HttpMethod.POST).header("User-Agent", USER_AGENT_NAME).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").header("Authorization", "Basic " + key).body(formData.getBytes(StandardCharsets.UTF_8));
    }

    protected String getBearerAuth() {
        return "Bearer " + this.retrieveTokenIfExpired();
    }

    protected String retrieveTokenIfExpired() {
        return this.accessToken.updateAndGet(t -> {
            Instant expiresAt = t == null ? null : t.expiresAt();
            return expiresAt != null && Instant.now().isBefore(expiresAt) ? t : this.getToken();
        }).token();
    }

    protected abstract AccessToken getToken();
}

