/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.client.auth;

import chat.giga.client.auth.AccessToken;
import chat.giga.client.auth.AuthClient;
import chat.giga.client.auth.TokenBasedAuthClient;
import chat.giga.http.client.HttpClient;
import chat.giga.http.client.HttpRequest;
import chat.giga.http.client.HttpResponse;
import chat.giga.model.AccessTokenByUserPasswordResponse;
import chat.giga.model.AccessTokenResponse;
import chat.giga.model.Scope;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Objects;

class UserPasswordAuthClient
extends TokenBasedAuthClient
implements AuthClient {
    private final String user;
    private final String password;
    private final Scope scope;
    private final HttpClient httpClient;
    private final String authApiUrl;

    public UserPasswordAuthClient(HttpClient httpClient, String user, String password, Scope scope, String authApiUrl) {
        this.httpClient = httpClient;
        this.user = user;
        this.password = password;
        this.scope = scope;
        this.authApiUrl = authApiUrl;
        this.validateParams();
    }

    private void validateParams() {
        Objects.requireNonNull(this.user, "user must not be null");
        Objects.requireNonNull(this.password, "password must not be null");
        Objects.requireNonNull(this.scope, "scope must not be null");
        Objects.requireNonNull(this.authApiUrl, "authApiUrl must not be null");
    }

    @Override
    public boolean supportsHttpClient() {
        return false;
    }

    @Override
    public void authenticate(HttpRequest.HttpRequestBuilder requestBuilder) {
        requestBuilder.header("Authorization", this.getBearerAuth());
    }

    @Override
    public HttpClient getHttpClient() {
        return null;
    }

    @Override
    public AccessToken getToken() {
        AccessTokenResponse token = this.oauth();
        return new AccessToken(token.accessToken(), Instant.ofEpochMilli(token.expiresAt()));
    }

    public AccessTokenResponse oauth() {
        HttpRequest httpRequest = this.getTokenRequest(this.authApiUrl + "/token", this.scope, this.user, this.password).build();
        try {
            HttpResponse httpResponse = this.httpClient.execute(httpRequest);
            AccessTokenByUserPasswordResponse response = (AccessTokenByUserPasswordResponse)this.objectMapper.readValue(httpResponse.body(), AccessTokenByUserPasswordResponse.class);
            return AccessTokenResponse.builder().accessToken(response.accessToken).expiresAt(response.expiresAt).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

