/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.model.completion;

import chat.giga.model.completion.ChoiceMessage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=ChatMessageBuilder.class)
public final class ChatMessage {
    @JsonProperty
    private final Role role;
    @JsonProperty
    private final String content;
    @JsonProperty(value="functions_state_id")
    private final String functionsStateId;
    @JsonProperty
    private final List<String> attachments;
    @JsonProperty
    private final String name;

    public static ChatMessage of(ChoiceMessage message) {
        return new ChatMessage(Role.fromValue(message.role().value()), message.content(), message.functionsStateId(), null, null);
    }

    @Generated
    ChatMessage(Role role, String content, String functionsStateId, List<String> attachments, String name) {
        this.role = role;
        this.content = content;
        this.functionsStateId = functionsStateId;
        this.attachments = attachments;
        this.name = name;
    }

    @Generated
    public static ChatMessageBuilder builder() {
        return new ChatMessageBuilder();
    }

    @Generated
    public Role role() {
        return this.role;
    }

    @Generated
    public String content() {
        return this.content;
    }

    @Generated
    public String functionsStateId() {
        return this.functionsStateId;
    }

    @Generated
    public List<String> attachments() {
        return this.attachments;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        Role this$role = this.role();
        Role other$role = other.role();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        String this$content = this.content();
        String other$content = other.content();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$functionsStateId = this.functionsStateId();
        String other$functionsStateId = other.functionsStateId();
        if (this$functionsStateId == null ? other$functionsStateId != null : !this$functionsStateId.equals(other$functionsStateId)) {
            return false;
        }
        List<String> this$attachments = this.attachments();
        List<String> other$attachments = other.attachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Role $role = this.role();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        String $content = this.content();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $functionsStateId = this.functionsStateId();
        result = result * 59 + ($functionsStateId == null ? 43 : $functionsStateId.hashCode());
        List<String> $attachments = this.attachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatMessage(role=" + String.valueOf((Object)this.role()) + ", content=" + this.content() + ", functionsStateId=" + this.functionsStateId() + ", attachments=" + String.valueOf(this.attachments()) + ", name=" + this.name() + ")";
    }

    public static enum Role {
        SYSTEM("system"),
        USER("user"),
        ASSISTANT("assistant"),
        FUNCTION("function");

        final String value;

        private Role(String v) {
            this.value = v;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static Role fromValue(String value) {
            for (Role b : Role.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class ChatMessageBuilder {
        @Generated
        private Role role;
        @Generated
        private String content;
        @Generated
        private String functionsStateId;
        @Generated
        private ArrayList<String> attachments;
        @Generated
        private String name;

        @Generated
        ChatMessageBuilder() {
        }

        @JsonProperty
        @Generated
        public ChatMessageBuilder role(Role role) {
            this.role = role;
            return this;
        }

        @JsonProperty
        @Generated
        public ChatMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        @JsonProperty(value="functions_state_id")
        @Generated
        public ChatMessageBuilder functionsStateId(String functionsStateId) {
            this.functionsStateId = functionsStateId;
            return this;
        }

        @Generated
        public ChatMessageBuilder attachment(String attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        @JsonProperty
        @Generated
        public ChatMessageBuilder attachments(Collection<? extends String> attachments) {
            if (attachments == null) {
                throw new NullPointerException("attachments cannot be null");
            }
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        @Generated
        public ChatMessageBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        @JsonProperty
        @Generated
        public ChatMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ChatMessage build() {
            return new ChatMessage(this.role, this.content, this.functionsStateId, switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.attachments.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.attachments));
            }, this.name);
        }

        @Generated
        public String toString() {
            return "ChatMessage.ChatMessageBuilder(role=" + String.valueOf((Object)this.role) + ", content=" + this.content + ", functionsStateId=" + this.functionsStateId + ", attachments=" + String.valueOf(this.attachments) + ", name=" + this.name + ")";
        }
    }
}

