/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.model.completion;

import chat.giga.jackson.FunctionCallJsonDeserializer;
import chat.giga.model.completion.ChatFunction;
import chat.giga.model.completion.ChatFunctionCall;
import chat.giga.model.completion.ChatFunctionCallEnum;
import chat.giga.model.completion.ChatMessage;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=CompletionRequestBuilder.class)
public final class CompletionRequest {
    @JsonProperty
    private final String model;
    @JsonProperty
    private final List<ChatMessage> messages;
    @JsonProperty(value="function_call")
    @JsonDeserialize(using=FunctionCallJsonDeserializer.class)
    private final Object functionCall;
    @JsonProperty(value="profanity_check")
    private final Boolean profanityCheck;
    @JsonProperty
    private final List<ChatFunction> functions;
    @JsonProperty
    private final Float temperature;
    @JsonProperty(value="top_p")
    private final Float topP;
    @JsonProperty
    private final Boolean stream;
    @JsonProperty(value="max_tokens")
    private final Integer maxTokens;
    @JsonProperty(value="repetition_penalty")
    private final Float repetitionPenalty;
    @JsonProperty(value="update_interval")
    private final Integer updateInterval;

    public static CompletionRequestBuilder builder() {
        return new CompletionRequestBuilder();
    }

    public static CompletionRequestBuilder builder(ChatFunctionCall functionCall) {
        return new CompletionRequestBuilder().functionCall(functionCall);
    }

    public static CompletionRequestBuilder builder(ChatFunctionCallEnum functionCall) {
        return new CompletionRequestBuilder().functionCall((Object)functionCall);
    }

    @Generated
    private static Object $default$functionCall() {
        return ChatFunctionCallEnum.AUTO;
    }

    @Generated
    private static Boolean $default$profanityCheck() {
        return false;
    }

    @Generated
    private static Boolean $default$stream() {
        return false;
    }

    @Generated
    private static Integer $default$updateInterval() {
        return 0;
    }

    @Generated
    CompletionRequest(String model, List<ChatMessage> messages, Object functionCall, Boolean profanityCheck, List<ChatFunction> functions, Float temperature, Float topP, Boolean stream, Integer maxTokens, Float repetitionPenalty, Integer updateInterval) {
        this.model = model;
        this.messages = messages;
        this.functionCall = functionCall;
        this.profanityCheck = profanityCheck;
        this.functions = functions;
        this.temperature = temperature;
        this.topP = topP;
        this.stream = stream;
        this.maxTokens = maxTokens;
        this.repetitionPenalty = repetitionPenalty;
        this.updateInterval = updateInterval;
    }

    @Generated
    public CompletionRequestBuilder toBuilder() {
        CompletionRequestBuilder builder = new CompletionRequestBuilder().model(this.model).functionCall(this.functionCall).profanityCheck(this.profanityCheck).temperature(this.temperature).topP(this.topP).stream(this.stream).maxTokens(this.maxTokens).repetitionPenalty(this.repetitionPenalty).updateInterval(this.updateInterval);
        if (this.messages != null) {
            builder.messages(this.messages);
        }
        if (this.functions != null) {
            builder.functions(this.functions);
        }
        return builder;
    }

    @Generated
    public String model() {
        return this.model;
    }

    @Generated
    public List<ChatMessage> messages() {
        return this.messages;
    }

    @Generated
    public Object functionCall() {
        return this.functionCall;
    }

    @Generated
    public Boolean profanityCheck() {
        return this.profanityCheck;
    }

    @Generated
    public List<ChatFunction> functions() {
        return this.functions;
    }

    @Generated
    public Float temperature() {
        return this.temperature;
    }

    @Generated
    public Float topP() {
        return this.topP;
    }

    @Generated
    public Boolean stream() {
        return this.stream;
    }

    @Generated
    public Integer maxTokens() {
        return this.maxTokens;
    }

    @Generated
    public Float repetitionPenalty() {
        return this.repetitionPenalty;
    }

    @Generated
    public Integer updateInterval() {
        return this.updateInterval;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompletionRequest)) {
            return false;
        }
        CompletionRequest other = (CompletionRequest)o;
        Boolean this$profanityCheck = this.profanityCheck();
        Boolean other$profanityCheck = other.profanityCheck();
        if (this$profanityCheck == null ? other$profanityCheck != null : !((Object)this$profanityCheck).equals(other$profanityCheck)) {
            return false;
        }
        Float this$temperature = this.temperature();
        Float other$temperature = other.temperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Float this$topP = this.topP();
        Float other$topP = other.topP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Boolean this$stream = this.stream();
        Boolean other$stream = other.stream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Integer this$maxTokens = this.maxTokens();
        Integer other$maxTokens = other.maxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Float this$repetitionPenalty = this.repetitionPenalty();
        Float other$repetitionPenalty = other.repetitionPenalty();
        if (this$repetitionPenalty == null ? other$repetitionPenalty != null : !((Object)this$repetitionPenalty).equals(other$repetitionPenalty)) {
            return false;
        }
        Integer this$updateInterval = this.updateInterval();
        Integer other$updateInterval = other.updateInterval();
        if (this$updateInterval == null ? other$updateInterval != null : !((Object)this$updateInterval).equals(other$updateInterval)) {
            return false;
        }
        String this$model = this.model();
        String other$model = other.model();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatMessage> this$messages = this.messages();
        List<ChatMessage> other$messages = other.messages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Object this$functionCall = this.functionCall();
        Object other$functionCall = other.functionCall();
        if (this$functionCall == null ? other$functionCall != null : !this$functionCall.equals(other$functionCall)) {
            return false;
        }
        List<ChatFunction> this$functions = this.functions();
        List<ChatFunction> other$functions = other.functions();
        return !(this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $profanityCheck = this.profanityCheck();
        result = result * 59 + ($profanityCheck == null ? 43 : ((Object)$profanityCheck).hashCode());
        Float $temperature = this.temperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Float $topP = this.topP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Boolean $stream = this.stream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Integer $maxTokens = this.maxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Float $repetitionPenalty = this.repetitionPenalty();
        result = result * 59 + ($repetitionPenalty == null ? 43 : ((Object)$repetitionPenalty).hashCode());
        Integer $updateInterval = this.updateInterval();
        result = result * 59 + ($updateInterval == null ? 43 : ((Object)$updateInterval).hashCode());
        String $model = this.model();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatMessage> $messages = this.messages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Object $functionCall = this.functionCall();
        result = result * 59 + ($functionCall == null ? 43 : $functionCall.hashCode());
        List<ChatFunction> $functions = this.functions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CompletionRequest(model=" + this.model() + ", messages=" + String.valueOf(this.messages()) + ", functionCall=" + String.valueOf(this.functionCall()) + ", profanityCheck=" + this.profanityCheck() + ", functions=" + String.valueOf(this.functions()) + ", temperature=" + this.temperature() + ", topP=" + this.topP() + ", stream=" + this.stream() + ", maxTokens=" + this.maxTokens() + ", repetitionPenalty=" + this.repetitionPenalty() + ", updateInterval=" + this.updateInterval() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class CompletionRequestBuilder {
        @Generated
        private String model;
        @Generated
        private ArrayList<ChatMessage> messages;
        @Generated
        private boolean functionCall$set;
        @Generated
        private Object functionCall$value;
        @Generated
        private boolean profanityCheck$set;
        @Generated
        private Boolean profanityCheck$value;
        @Generated
        private ArrayList<ChatFunction> functions;
        @Generated
        private Float temperature;
        @Generated
        private Float topP;
        @Generated
        private boolean stream$set;
        @Generated
        private Boolean stream$value;
        @Generated
        private Integer maxTokens;
        @Generated
        private Float repetitionPenalty;
        @Generated
        private boolean updateInterval$set;
        @Generated
        private Integer updateInterval$value;

        @Generated
        CompletionRequestBuilder() {
        }

        @JsonProperty
        @Generated
        public CompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public CompletionRequestBuilder message(ChatMessage message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        @JsonProperty
        @Generated
        public CompletionRequestBuilder messages(Collection<? extends ChatMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        @Generated
        public CompletionRequestBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        @JsonProperty(value="function_call")
        @JsonDeserialize(using=FunctionCallJsonDeserializer.class)
        @Generated
        public CompletionRequestBuilder functionCall(Object functionCall) {
            this.functionCall$value = functionCall;
            this.functionCall$set = true;
            return this;
        }

        @JsonProperty(value="profanity_check")
        @Generated
        public CompletionRequestBuilder profanityCheck(Boolean profanityCheck) {
            this.profanityCheck$value = profanityCheck;
            this.profanityCheck$set = true;
            return this;
        }

        @Generated
        public CompletionRequestBuilder function(ChatFunction function) {
            if (this.functions == null) {
                this.functions = new ArrayList();
            }
            this.functions.add(function);
            return this;
        }

        @JsonProperty
        @Generated
        public CompletionRequestBuilder functions(Collection<? extends ChatFunction> functions) {
            if (functions == null) {
                throw new NullPointerException("functions cannot be null");
            }
            if (this.functions == null) {
                this.functions = new ArrayList();
            }
            this.functions.addAll(functions);
            return this;
        }

        @Generated
        public CompletionRequestBuilder clearFunctions() {
            if (this.functions != null) {
                this.functions.clear();
            }
            return this;
        }

        @JsonProperty
        @Generated
        public CompletionRequestBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        @Generated
        public CompletionRequestBuilder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        @JsonProperty
        @Generated
        public CompletionRequestBuilder stream(Boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        @JsonProperty(value="max_tokens")
        @Generated
        public CompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="repetition_penalty")
        @Generated
        public CompletionRequestBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        @JsonProperty(value="update_interval")
        @Generated
        public CompletionRequestBuilder updateInterval(Integer updateInterval) {
            this.updateInterval$value = updateInterval;
            this.updateInterval$set = true;
            return this;
        }

        @Generated
        public CompletionRequest build() {
            List<ChatMessage> messages = switch (this.messages == null ? 0 : this.messages.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.messages.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ChatMessage>(this.messages));
            };
            List<ChatFunction> functions = switch (this.functions == null ? 0 : this.functions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.functions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ChatFunction>(this.functions));
            };
            Object functionCall$value = this.functionCall$value;
            if (!this.functionCall$set) {
                functionCall$value = CompletionRequest.$default$functionCall();
            }
            Boolean profanityCheck$value = this.profanityCheck$value;
            if (!this.profanityCheck$set) {
                profanityCheck$value = CompletionRequest.$default$profanityCheck();
            }
            Boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = CompletionRequest.$default$stream();
            }
            Integer updateInterval$value = this.updateInterval$value;
            if (!this.updateInterval$set) {
                updateInterval$value = CompletionRequest.$default$updateInterval();
            }
            return new CompletionRequest(this.model, messages, functionCall$value, profanityCheck$value, functions, this.temperature, this.topP, stream$value, this.maxTokens, this.repetitionPenalty, updateInterval$value);
        }

        @Generated
        public String toString() {
            return "CompletionRequest.CompletionRequestBuilder(model=" + this.model + ", messages=" + String.valueOf(this.messages) + ", functionCall$value=" + String.valueOf(this.functionCall$value) + ", profanityCheck$value=" + this.profanityCheck$value + ", functions=" + String.valueOf(this.functions) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", stream$value=" + this.stream$value + ", maxTokens=" + this.maxTokens + ", repetitionPenalty=" + this.repetitionPenalty + ", updateInterval$value=" + this.updateInterval$value + ")";
        }
    }
}

