/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.util;

import chat.giga.http.client.HttpClientException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public final class RetryUtils {
    public static <T> T retry401(Supplier<T> supplier, int maxRetries) {
        for (int retries = 0; retries <= maxRetries; ++retries) {
            try {
                return supplier.get();
            }
            catch (HttpClientException e) {
                if (e.statusCode() == 401) {
                    continue;
                }
                throw e;
            }
        }
        throw new IllegalStateException(String.format("Retries exhausted after %s attempts", maxRetries));
    }

    public static <T> CompletableFuture<T> retry401Async(Supplier<CompletableFuture<T>> supplier, int maxRetries) {
        CompletionStage<T> future = supplier.get();
        for (int i = 0; i <= maxRetries; ++i) {
            future = ((CompletableFuture)future.handleAsync((r, th) -> {
                if (th != null) {
                    HttpClientException e;
                    Throwable patt1117$temp = th.getCause();
                    if (patt1117$temp instanceof HttpClientException && (e = (HttpClientException)patt1117$temp).statusCode() == 401) {
                        return (CompletableFuture)supplier.get();
                    }
                    return CompletableFuture.failedFuture(th);
                }
                return CompletableFuture.completedFuture(r);
            })).thenCompose(Function.identity());
        }
        return future;
    }

    @Generated
    private RetryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

