/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.springai.autoconfigure;

import chat.giga.springai.GigaChatEmbeddingModel;
import chat.giga.springai.GigaChatModel;
import chat.giga.springai.api.GigaChatApiProperties;
import chat.giga.springai.api.GigaChatInternalProperties;
import chat.giga.springai.api.auth.GigaChatAuthProperties;
import chat.giga.springai.api.chat.GigaChatApi;
import chat.giga.springai.autoconfigure.GigaChatChatProperties;
import chat.giga.springai.autoconfigure.GigaChatEmbeddingProperties;
import io.micrometer.observation.ObservationRegistry;
import java.io.InputStream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import nl.altindag.ssl.pem.util.PemUtils;
import nl.altindag.ssl.util.KeyManagerUtils;
import nl.altindag.ssl.util.TrustManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.model.chat.observation.autoconfigure.ChatObservationAutoConfiguration;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.autoconfigure.ToolCallingAutoConfiguration;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, WebClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class, ChatObservationAutoConfiguration.class, ToolCallingAutoConfiguration.class})
@EnableConfigurationProperties(value={GigaChatChatProperties.class, GigaChatEmbeddingProperties.class})
@ConditionalOnClass(value={GigaChatApi.class})
@ConditionalOnProperty(name={"spring.ai.model.chat"}, havingValue="gigachat", matchIfMissing=true)
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class, RestClientAutoConfiguration.class, WebClientAutoConfiguration.class, ToolCallingAutoConfiguration.class})
public class GigaChatAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GigaChatAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public GigaChatApi gigaChatApi(GigaChatApiProperties gigaChatApiProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ResponseErrorHandler responseErrorHandler, ObjectProvider<SslBundles> sslBundlesProvider) {
        KeyManagerFactory keyManagerFactory = null;
        TrustManagerFactory trustManagerFactory = null;
        GigaChatAuthProperties auth = gigaChatApiProperties.getAuth();
        if (auth.isCertsAuth()) {
            SslBundles sslBundles = (SslBundles)sslBundlesProvider.getIfUnique();
            String sslBundleName = auth.getCerts().getSslBundle();
            if (sslBundleName != null) {
                if (sslBundles != null) {
                    SslBundle sslBundle = sslBundles.getBundle(sslBundleName);
                    keyManagerFactory = sslBundle.getManagers().getKeyManagerFactory();
                    trustManagerFactory = sslBundle.getManagers().getTrustManagerFactory();
                } else {
                    log.warn("SslBundles bean was not found");
                }
            } else {
                keyManagerFactory = KeyManagerUtils.createKeyManagerFactory((KeyManager)PemUtils.loadIdentityMaterial((InputStream)auth.getCerts().getCertificate().getInputStream(), (InputStream)auth.getCerts().getPrivateKey().getInputStream()));
            }
        } else if (gigaChatApiProperties.getClientKey() != null && gigaChatApiProperties.getClientCertificate() != null) {
            keyManagerFactory = KeyManagerUtils.createKeyManagerFactory((KeyManager)PemUtils.loadIdentityMaterial((InputStream)gigaChatApiProperties.getClientCertificate().getInputStream(), (InputStream)gigaChatApiProperties.getClientKey().getInputStream()));
        }
        if (trustManagerFactory == null && auth.getCerts().getCaCerts() != null) {
            trustManagerFactory = TrustManagerUtils.createTrustManagerFactory((TrustManager)PemUtils.loadTrustMaterial((InputStream[])new InputStream[]{auth.getCerts().getCaCerts().getInputStream()}));
        }
        return new GigaChatApi(gigaChatApiProperties, (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder), responseErrorHandler, keyManagerFactory, trustManagerFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public GigaChatModel gigaChatChatModel(GigaChatApi gigaChatApi, GigaChatChatProperties chatProperties, RetryTemplate retryTemplate, ToolCallingManager toolCallingManager, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention, ObjectProvider<ToolExecutionEligibilityPredicate> toolExecutionEligibilityPredicate, GigaChatInternalProperties internalProperties) {
        GigaChatModel gigaChatModel = GigaChatModel.builder().gigaChatApi(gigaChatApi).defaultOptions(chatProperties.getOptions()).retryTemplate(retryTemplate).toolCallingManager(toolCallingManager).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).toolExecutionEligibilityPredicate((ToolExecutionEligibilityPredicate)toolExecutionEligibilityPredicate.getIfUnique(DefaultToolExecutionEligibilityPredicate::new)).internalProperties(internalProperties).build();
        observationConvention.ifAvailable(arg_0 -> ((GigaChatModel)gigaChatModel).setObservationConvention(arg_0));
        return gigaChatModel;
    }

    @Bean
    @ConditionalOnMissingBean
    public GigaChatEmbeddingModel gigaChatEmbeddingModel(GigaChatApi gigaChatApi, GigaChatEmbeddingProperties gigaChatEmbeddingProperties, RetryTemplate retryTemplate, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        GigaChatEmbeddingModel gigaChatEmbeddingModel = new GigaChatEmbeddingModel(gigaChatApi, gigaChatEmbeddingProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((GigaChatEmbeddingModel)gigaChatEmbeddingModel).setObservationConvention(arg_0));
        return gigaChatEmbeddingModel;
    }

    @Bean
    @ConfigurationProperties(prefix="spring.ai.gigachat.auth")
    public GigaChatAuthProperties gigaChatAuthProperties() {
        return new GigaChatAuthProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.ai.gigachat.internal")
    public GigaChatInternalProperties gigaChatInternalProperties() {
        return new GigaChatInternalProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.ai.gigachat")
    public GigaChatApiProperties gigaChatApiProperties(GigaChatAuthProperties gigaChatAuthProperties, GigaChatInternalProperties gigaChatInternalProperties) {
        GigaChatApiProperties gigaChatApiProperties = new GigaChatApiProperties();
        gigaChatApiProperties.setAuth(gigaChatAuthProperties);
        gigaChatApiProperties.setInternal(gigaChatInternalProperties);
        return gigaChatApiProperties;
    }
}

