/*
 * Decompiled with CFR 0.152.
 */
package chat.giga.springai.autoconfigure;

import chat.giga.springai.GigaChatEmbeddingOptions;
import chat.giga.springai.api.chat.embedding.EmbeddingsModel;
import org.springframework.ai.document.MetadataMode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.gigachat.embedding")
public class GigaChatEmbeddingProperties {
    public static final String CONFIG_PREFIX = "spring.ai.gigachat.embedding";
    public static final String DEFAULT_EMBEDDING_MODEL = EmbeddingsModel.EMBEDDINGS.getName();
    public static final String DEFAULT_EMBEDDINGS_PATH = "/v1/embeddings";
    private boolean enabled = true;
    private MetadataMode metadataMode = MetadataMode.EMBED;
    private String embeddingsPath = "/v1/embeddings";
    @NestedConfigurationProperty
    private GigaChatEmbeddingOptions options = GigaChatEmbeddingOptions.builder().withModel(DEFAULT_EMBEDDING_MODEL).build();

    public GigaChatEmbeddingOptions getOptions() {
        return this.options;
    }

    public void setOptions(GigaChatEmbeddingOptions options) {
        this.options = options;
    }

    public MetadataMode getMetadataMode() {
        return this.metadataMode;
    }

    public void setMetadataMode(MetadataMode metadataMode) {
        this.metadataMode = metadataMode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getEmbeddingsPath() {
        return this.embeddingsPath;
    }

    public void setEmbeddingsPath(String embeddingsPath) {
        this.embeddingsPath = embeddingsPath;
    }
}

