/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.http;

import cl.daplay.jsurbtc.HTTPClient;
import cl.daplay.jsurbtc.Signer;
import cl.daplay.jsurbtc.fun.ThrowingSupplier;
import cl.daplay.jsurbtc.model.JSurbtcException;

public final class RetryHTTPClient
implements HTTPClient {
    private final HTTPClient delegate;
    private final int limit;

    public RetryHTTPClient(HTTPClient delegate, int limit) {
        this.delegate = delegate;
        this.limit = limit;
    }

    @Override
    public <T> T get(String path, Signer signer, HTTPClient.HTTPResponseHandler<T> responseHandler) throws Exception {
        return (T)this.retry(() -> this.delegate.get(path, signer, responseHandler));
    }

    @Override
    public <T> T put(String path, Signer signer, String jsonBody, HTTPClient.HTTPResponseHandler<T> responseHandler) throws Exception {
        return (T)this.retry(() -> this.delegate.put(path, signer, jsonBody, responseHandler));
    }

    @Override
    public <T> T post(String path, Signer signer, String jsonBody, HTTPClient.HTTPResponseHandler<T> responseHandler) throws Exception {
        return (T)this.retry(() -> this.delegate.post(path, signer, jsonBody, responseHandler));
    }

    private <T> T retry(ThrowingSupplier<T> supplier) throws Exception {
        int retries = 0;
        Exception lastEx = null;
        while (true) {
            try {
                return supplier.get();
            }
            catch (Exception ex) {
                if (ex instanceof JSurbtcException) {
                    boolean invalidCredentials;
                    JSurbtcException surbtcException = (JSurbtcException)ex;
                    boolean bl = invalidCredentials = surbtcException.httpStatusCode == 401;
                    if (!invalidCredentials) {
                        throw ex;
                    }
                }
                lastEx = ex;
                if (++retries < this.limit) continue;
                throw lastEx;
            }
            break;
        }
    }
}

