/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.jackson.model.order;

import cl.daplay.jsurbtc.jackson.model.JacksonAmount;
import cl.daplay.jsurbtc.model.Order;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonOrder
implements Order,
Serializable {
    private static final long serialVersionUID = 20170806L;
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="created_at")
    private Instant createdAt;
    @JsonProperty(value="market_id")
    private String marketId;
    @JsonProperty(value="account_id")
    private long accountId;
    @JsonProperty(value="fee_currency")
    private String feeCurrency;
    @JsonProperty(value="price_type")
    private String priceType;
    @JsonProperty(value="limit")
    private JacksonAmount limit;
    @JsonProperty(value="amount")
    private JacksonAmount amount;
    @JsonProperty(value="original_amount")
    private JacksonAmount originalAmount;
    @JsonProperty(value="traded_amount")
    private JacksonAmount tradedAmount;
    @JsonProperty(value="total_exchanged")
    private JacksonAmount totalExchanged;
    @JsonProperty(value="paid_fee")
    private JacksonAmount paidFee;

    @JsonCreator
    public JacksonOrder(@JsonProperty(value="id") long id, @JsonProperty(value="type") String type, @JsonProperty(value="state") String state, @JsonProperty(value="created_at") Instant createdAt, @JsonProperty(value="market_id") String marketId, @JsonProperty(value="account_id") long accountId, @JsonProperty(value="fee_currency") String feeCurrency, @JsonProperty(value="price_type") String priceType, @JsonProperty(value="limit") JacksonAmount limit, @JsonProperty(value="amount") JacksonAmount amount, @JsonProperty(value="original_amount") JacksonAmount originalAmount, @JsonProperty(value="traded_amount") JacksonAmount tradedAmount, @JsonProperty(value="total_exchanged") JacksonAmount totalExchanged, @JsonProperty(value="paid_fee") JacksonAmount paidFee) {
        this.id = id;
        this.type = type;
        this.state = state;
        this.createdAt = createdAt;
        this.marketId = marketId;
        this.accountId = accountId;
        this.feeCurrency = feeCurrency;
        this.priceType = priceType;
        this.limit = limit;
        this.amount = amount;
        this.originalAmount = originalAmount;
        this.tradedAmount = tradedAmount;
        this.totalExchanged = totalExchanged;
        this.paidFee = paidFee;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getAccountId() {
        return this.accountId;
    }

    @Override
    public String getFeeCurrency() {
        return this.feeCurrency;
    }

    @Override
    public String getPriceType() {
        return this.priceType;
    }

    @Override
    public BigDecimal getLimit() {
        return this.limit.getAmount();
    }

    @Override
    public String getLimitCurrency() {
        return this.limit.getCurrency();
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount.getAmount();
    }

    @Override
    public String getAmountCurrency() {
        return this.amount.getCurrency();
    }

    @Override
    public BigDecimal getOriginalAmount() {
        return this.originalAmount.getAmount();
    }

    @Override
    public String getOriginalAmountCurrency() {
        return this.originalAmount.getCurrency();
    }

    @Override
    public BigDecimal getTradedAmount() {
        return this.tradedAmount.getAmount();
    }

    @Override
    public String getTradedAmountCurrency() {
        return this.tradedAmount.getCurrency();
    }

    @Override
    public BigDecimal getTotalExchanged() {
        return this.totalExchanged.getAmount();
    }

    @Override
    public String getTotalExchangedCurrency() {
        return this.totalExchanged.getCurrency();
    }

    @Override
    public BigDecimal getPaidFee() {
        return this.paidFee.getAmount();
    }

    @Override
    public String getPaidFeeCurrency() {
        return this.paidFee.getCurrency();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonOrder order = (JacksonOrder)o;
        if (this.id != order.id) {
            return false;
        }
        if (this.marketId != order.marketId) {
            return false;
        }
        if (this.accountId != order.accountId) {
            return false;
        }
        if (this.type != null ? !this.type.equals(order.type) : order.type != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(order.state) : order.state != null) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(order.createdAt) : order.createdAt != null) {
            return false;
        }
        if (this.feeCurrency != null ? !this.feeCurrency.equals(order.feeCurrency) : order.feeCurrency != null) {
            return false;
        }
        if (this.priceType != null ? !this.priceType.equals(order.priceType) : order.priceType != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(order.limit) : order.limit != null) {
            return false;
        }
        if (this.amount != null ? !this.amount.equals(order.amount) : order.amount != null) {
            return false;
        }
        if (this.originalAmount != null ? !this.originalAmount.equals(order.originalAmount) : order.originalAmount != null) {
            return false;
        }
        if (this.tradedAmount != null ? !this.tradedAmount.equals(order.tradedAmount) : order.tradedAmount != null) {
            return false;
        }
        if (this.totalExchanged != null ? !this.totalExchanged.equals(order.totalExchanged) : order.totalExchanged != null) {
            return false;
        }
        return this.paidFee != null ? this.paidFee.equals(order.paidFee) : order.paidFee == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.marketId != null ? this.marketId.hashCode() : 0);
        result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.feeCurrency != null ? this.feeCurrency.hashCode() : 0);
        result = 31 * result + (this.priceType != null ? this.priceType.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.originalAmount != null ? this.originalAmount.hashCode() : 0);
        result = 31 * result + (this.tradedAmount != null ? this.tradedAmount.hashCode() : 0);
        result = 31 * result + (this.totalExchanged != null ? this.totalExchanged.hashCode() : 0);
        result = 31 * result + (this.paidFee != null ? this.paidFee.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Order{id=" + this.id + ", type='" + this.type + '\'' + ", state='" + this.state + '\'' + ", createdAt=" + this.createdAt + ", marketId=" + this.marketId + ", accountId=" + this.accountId + ", feeCurrency=" + this.feeCurrency + ", priceType='" + this.priceType + '\'' + ", limit='" + this.limit + '\'' + ", amount=" + this.amount + ", originalAmount=" + this.originalAmount + ", tradedAmount=" + this.tradedAmount + ", totalExchanged=" + this.totalExchanged + ", paidFee=" + this.paidFee + '}';
    }
}

