/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.jackson.model.trades;

import cl.daplay.jsurbtc.model.Trades;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Objects;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
@JsonPropertyOrder(value={"timestamp", "amount", "price", "direction"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonTransaction
implements Trades.Transaction,
Serializable,
Comparable<Trades.Transaction> {
    private static final long serialVersionUID = 20171027L;
    @JsonProperty(value="timestamp")
    private final Instant timestamp;
    @JsonProperty(value="amount")
    private final BigDecimal amount;
    @JsonProperty(value="price")
    private final BigDecimal price;
    @JsonProperty(value="direction")
    private final String direction;

    public JacksonTransaction(@JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="direction") String direction) {
        this.timestamp = timestamp;
        this.amount = amount;
        this.price = price;
        this.direction = direction;
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    @Override
    public String getDirection() {
        return this.direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonTransaction that = (JacksonTransaction)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.amount, that.amount) && Objects.equals(this.price, that.price) && Objects.equals(this.direction, that.direction);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.amount, this.price, this.direction);
    }

    public String toString() {
        return "Transaction{timestamp=" + this.timestamp + ", amount=" + this.amount + ", price=" + this.price + ", direction=" + this.direction + '}';
    }

    @Override
    public int compareTo(Trades.Transaction o) {
        return this.timestamp.compareTo(o.getTimestamp());
    }
}

