/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.api.pojos;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"prettyPrint", "logLocationInfo", "parseContentFieldsInJsonOutput", "disabledFields", "contentFieldsDataMasking"})
public class JsonOutput {
    @JsonProperty(value="prettyPrint")
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicate if log entries should be formatted or single line")
    @Expression(value=ExpressionSupport.SUPPORTED)
    private boolean prettyPrint;
    @JsonProperty(value="logLocationInfo")
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicate if location information should be logged")
    @Expression(value=ExpressionSupport.SUPPORTED)
    private boolean logLocationInfo;
    @JsonProperty(value="parseContentFieldsInJsonOutput")
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicate if Content fields should be parsed as part of the JSON logger output")
    @Expression(value=ExpressionSupport.SUPPORTED)
    private boolean parseContentFieldsInJsonOutput;
    @JsonProperty(value="disabledFields")
    @Parameter
    @Optional
    @Summary(value="Indicate which fields (from JSON output) should be disabled from logging separated by comma. They should match the exact name given in loggerProcessor.json schema")
    @Example(value="message,content")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String disabledFields;
    @JsonProperty(value="contentFieldsDataMasking")
    @Parameter
    @Optional
    @Summary(value="Indicate which fields (inside a content type with JSON output only) should be masked before from logging separated by comma. They can be JSON keys or JSON paths. If empty, no masking will be applied. Recommendation: This value should be based on external property")
    @Example(value="client_secret,password,$.myArray[1].someField,$..path.to.a.field")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String contentFieldsDataMasking;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="prettyPrint")
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @JsonProperty(value="prettyPrint")
    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @JsonProperty(value="logLocationInfo")
    public boolean isLogLocationInfo() {
        return this.logLocationInfo;
    }

    @JsonProperty(value="logLocationInfo")
    public void setLogLocationInfo(boolean logLocationInfo) {
        this.logLocationInfo = logLocationInfo;
    }

    @JsonProperty(value="parseContentFieldsInJsonOutput")
    public boolean isParseContentFieldsInJsonOutput() {
        return this.parseContentFieldsInJsonOutput;
    }

    @JsonProperty(value="parseContentFieldsInJsonOutput")
    public void setParseContentFieldsInJsonOutput(boolean parseContentFieldsInJsonOutput) {
        this.parseContentFieldsInJsonOutput = parseContentFieldsInJsonOutput;
    }

    @JsonProperty(value="disabledFields")
    public String getDisabledFields() {
        return this.disabledFields;
    }

    @JsonProperty(value="disabledFields")
    public void setDisabledFields(String disabledFields) {
        this.disabledFields = disabledFields;
    }

    @JsonProperty(value="contentFieldsDataMasking")
    public String getContentFieldsDataMasking() {
        return this.contentFieldsDataMasking;
    }

    @JsonProperty(value="contentFieldsDataMasking")
    public void setContentFieldsDataMasking(String contentFieldsDataMasking) {
        this.contentFieldsDataMasking = contentFieldsDataMasking;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("prettyPrint", this.prettyPrint).append("logLocationInfo", this.logLocationInfo).append("parseContentFieldsInJsonOutput", this.parseContentFieldsInJsonOutput).append("disabledFields", (Object)this.disabledFields).append("contentFieldsDataMasking", (Object)this.contentFieldsDataMasking).append("additionalProperties", this.additionalProperties).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.prettyPrint).append((Object)this.disabledFields).append(this.logLocationInfo).append(this.parseContentFieldsInJsonOutput).append(this.additionalProperties).append((Object)this.contentFieldsDataMasking).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JsonOutput)) {
            return false;
        }
        JsonOutput rhs = (JsonOutput)other;
        return new EqualsBuilder().append(this.prettyPrint, rhs.prettyPrint).append((Object)this.disabledFields, (Object)rhs.disabledFields).append(this.logLocationInfo, rhs.logLocationInfo).append(this.parseContentFieldsInJsonOutput, rhs.parseContentFieldsInJsonOutput).append(this.additionalProperties, rhs.additionalProperties).append((Object)this.contentFieldsDataMasking, (Object)rhs.contentFieldsDataMasking).isEquals();
    }
}

