/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mule.extension.jsonlogger.api.pojos.LoggerProcessor;
import org.mule.extension.jsonlogger.api.pojos.Priority;
import org.mule.extension.jsonlogger.api.pojos.ScopeTracePoint;
import org.mule.extension.jsonlogger.internal.JsonloggerConfiguration;
import org.mule.extension.jsonlogger.internal.datamask.JsonMasker;
import org.mule.extension.jsonlogger.internal.singleton.ConfigsSingleton;
import org.mule.extension.jsonlogger.internal.singleton.LogEventSingleton;
import org.mule.extension.jsonlogger.internal.singleton.ObjectMapperSingleton;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonloggerOperations {
    protected transient Logger jsonLogger;
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonloggerOperations.class);
    private final Result<Void, Void> VOID_RESULT = Result.builder().build();
    @Inject
    ObjectMapperSingleton om;
    @Inject
    LogEventSingleton logEvent;
    @Inject
    ConfigsSingleton configs;
    @Inject
    private TransformationService transformationService;

    @Execution(value=ExecutionType.BLOCKING)
    public void logger(@ParameterGroup(name="Logger") @Expression(value=ExpressionSupport.NOT_SUPPORTED) LoggerProcessor loggerProcessor, CorrelationInfo correlationInfo, ComponentLocation location, @Config JsonloggerConfiguration config, FlowListener flowListener, CompletionCallback<Void, Void> callback) {
        Long loggerTimestamp;
        Long initialTimestamp = loggerTimestamp = Long.valueOf(System.currentTimeMillis());
        this.initLoggerCategory(loggerProcessor.getCategory());
        LOGGER.debug("correlationInfo.getEventId(): " + correlationInfo.getEventId());
        LOGGER.debug("correlationInfo.getCorrelationId(): " + correlationInfo.getCorrelationId());
        try {
            initialTimestamp = config.getCachedTimerTimestamp(correlationInfo.getCorrelationId(), initialTimestamp);
        }
        catch (Exception e) {
            LOGGER.error("initialTimestamp could not be retrieved from the cache config. Defaulting to current System.currentTimeMillis()", (Throwable)e);
        }
        Long elapsed = loggerTimestamp - initialTimestamp;
        if (elapsed == 0L) {
            LOGGER.debug("configuring flowListener....");
            flowListener.onComplete((Runnable)new TimerRemoverRunnable(correlationInfo.getCorrelationId(), config));
        } else {
            LOGGER.debug("flowListener already configured");
        }
        if (this.isLogEnabled(loggerProcessor.getPriority().toString()).booleanValue()) {
            ArrayList disabledFields = config.getJsonOutput().getDisabledFields() != null ? Arrays.asList(config.getJsonOutput().getDisabledFields().split(",")) : new ArrayList();
            LOGGER.debug("The following fields will be disabled for logging: " + disabledFields);
            HashMap typedValuesAsString = new HashMap();
            HashMap typedValuesAsJsonNode = new HashMap();
            try {
                PropertyUtils.describe((Object)loggerProcessor).forEach((k, v) -> {
                    if (disabledFields.stream().anyMatch(k::equals)) {
                        try {
                            BeanUtils.setProperty((Object)loggerProcessor, (String)k, null);
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed disabling field: " + k, (Throwable)e);
                        }
                    } else if (v != null) {
                        try {
                            if (v instanceof ParameterResolver) {
                                v = ((ParameterResolver)v).resolve();
                            }
                            if (v.getClass().getCanonicalName().equals("org.mule.runtime.api.metadata.TypedValue")) {
                                LOGGER.debug("org.mule.runtime.api.metadata.TypedValue type was found for field: " + k);
                                TypedValue typedVal = (TypedValue)v;
                                LOGGER.debug("Parsing TypedValue for field " + k);
                                LOGGER.debug("TypedValue MediaType: " + typedVal.getDataType().getMediaType());
                                LOGGER.debug("TypedValue Type: " + typedVal.getDataType().getType().getCanonicalName());
                                LOGGER.debug("TypedValue Class: " + ((InputStream)typedVal.getValue()).getClass().getCanonicalName());
                                BeanUtils.setProperty((Object)loggerProcessor, (String)k, null);
                                if (typedVal.getValue() != null) {
                                    if (config.getJsonOutput().isParseContentFieldsInJsonOutput()) {
                                        if (typedVal.getDataType().getMediaType().getPrimaryType().equals("application") && typedVal.getDataType().getMediaType().getSubType().equals("json")) {
                                            ArrayList<String> dataMaskingFields = config.getJsonOutput().getContentFieldsDataMasking() != null ? Arrays.asList(config.getJsonOutput().getContentFieldsDataMasking().split(",")) : new ArrayList<String>();
                                            LOGGER.debug("The following JSON keys/paths will be masked for logging: " + dataMaskingFields);
                                            if (!dataMaskingFields.isEmpty()) {
                                                JsonNode tempContentNode = this.om.getObjectMapper().readTree((InputStream)typedVal.getValue());
                                                JsonMasker masker = new JsonMasker(dataMaskingFields, true);
                                                JsonNode masked = masker.mask(tempContentNode);
                                                typedValuesAsJsonNode.put(k, masked);
                                            } else {
                                                typedValuesAsJsonNode.put(k, this.om.getObjectMapper().readTree((InputStream)typedVal.getValue()));
                                            }
                                        } else {
                                            typedValuesAsString.put(k, (String)this.transformationService.transform(typedVal.getValue(), typedVal.getDataType(), DataType.TEXT_STRING));
                                        }
                                    } else {
                                        typedValuesAsString.put(k, (String)this.transformationService.transform(typedVal.getValue(), typedVal.getDataType(), DataType.TEXT_STRING));
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed parsing field: " + k, (Throwable)e);
                            typedValuesAsString.put(k, "Error parsing expression. See logs for details.");
                        }
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Unknown error while processing the logger object", (Throwable)e);
            }
            ObjectNode mergedLogger = this.om.getObjectMapper().createObjectNode();
            mergedLogger.setAll((ObjectNode)this.om.getObjectMapper().valueToTree((Object)loggerProcessor));
            mergedLogger.put("elapsed", elapsed);
            if (config.getJsonOutput().isLogLocationInfo()) {
                Map<String, String> locationInfo = this.locationInfoToMap(location);
                mergedLogger.putPOJO("locationInfo", locationInfo);
            }
            mergedLogger.put("timestamp", this.getFormattedTimestamp(loggerTimestamp));
            if (!typedValuesAsString.isEmpty()) {
                JsonNode typedValuesNode = this.om.getObjectMapper().valueToTree(typedValuesAsString);
                mergedLogger.setAll((ObjectNode)typedValuesNode);
            }
            if (!typedValuesAsJsonNode.isEmpty()) {
                mergedLogger.setAll(typedValuesAsJsonNode);
            }
            mergedLogger.setAll((ObjectNode)this.om.getObjectMapper().valueToTree((Object)config.getGlobalSettings()));
            mergedLogger.put("threadName", Thread.currentThread().getName());
            String finalLog = this.printObjectToLog(mergedLogger, loggerProcessor.getPriority().toString(), config.getJsonOutput().isPrettyPrint());
            if (config.getExternalDestination() != null) {
                LOGGER.debug("config.getExternalDestination().getSupportedCategories().isEmpty(): " + config.getExternalDestination().getSupportedCategories().isEmpty());
                LOGGER.debug("config.getExternalDestination().getSupportedCategories().contains(jsonLogger.getName()): " + config.getExternalDestination().getSupportedCategories().contains(this.jsonLogger.getName()));
                if (this.configs.getConfig(config.getConfigName()).getExternalDestination().getSupportedCategories().isEmpty() || config.getExternalDestination().getSupportedCategories().contains(this.jsonLogger.getName())) {
                    LOGGER.debug(this.jsonLogger.getName() + " is a supported category for external destination");
                    this.logEvent.publishToExternalDestination(correlationInfo.getEventId(), finalLog, config.getConfigName());
                }
            }
        } else {
            LOGGER.debug("Avoiding logger operation logic execution due to log priority not being enabled");
        }
        callback.success(this.VOID_RESULT);
    }

    @Execution(value=ExecutionType.BLOCKING)
    @MediaType(value="application/json")
    public void loggerScope(@DisplayName(value="Module configuration") @Example(value="JSON_Logger_Config") @Summary(value="Indicate which Global config should be associated with this Scope.") String configurationRef, @Optional(defaultValue="INFO") Priority priority, @Optional(defaultValue="OUTBOUND_REQUEST_SCOPE") ScopeTracePoint scopeTracePoint, @Optional @Summary(value="If not set, by default will log to the org.mule.extension.jsonlogger.JsonLogger category") String category, @Optional(defaultValue="#[correlationId]") @Placement(tab="Advanced") String correlationId, ComponentLocation location, CorrelationInfo correlationInfo, FlowListener flowListener, Chain operations, CompletionCallback<Object, Object> callback) {
        Long loggerTimestamp;
        Long initialTimestamp = loggerTimestamp = Long.valueOf(System.currentTimeMillis());
        this.initLoggerCategory(category);
        LOGGER.debug("correlationInfo.getEventId(): " + correlationInfo.getEventId());
        LOGGER.debug("correlationInfo.getCorrelationId(): " + correlationInfo.getCorrelationId());
        try {
            initialTimestamp = this.configs.getConfig(configurationRef).getCachedTimerTimestamp(correlationInfo.getCorrelationId(), initialTimestamp);
        }
        catch (Exception e) {
            LOGGER.error("initialTimestamp could not be retrieved from the cache config. Defaulting to current System.currentTimeMillis()", (Throwable)e);
        }
        Long elapsed = loggerTimestamp - initialTimestamp;
        if (elapsed == 0L) {
            LOGGER.debug("configuring flowListener....");
            flowListener.onComplete((Runnable)new TimerRemoverRunnable(correlationInfo.getCorrelationId(), this.configs.getConfig(configurationRef)));
        } else {
            LOGGER.debug("flowListener already configured");
        }
        if (this.isLogEnabled(priority.toString()).booleanValue()) {
            ObjectNode loggerProcessor = this.om.getObjectMapper().createObjectNode();
            loggerProcessor.put("correlationId", correlationId);
            loggerProcessor.put("tracePoint", scopeTracePoint.toString() + "_BEFORE");
            loggerProcessor.put("priority", priority.toString());
            loggerProcessor.put("elapsed", elapsed);
            loggerProcessor.put("scopeElapsed", 0);
            if (this.configs.getConfig(configurationRef).getJsonOutput().isLogLocationInfo()) {
                Map<String, String> locationInfoMap = this.locationInfoToMap(location);
                loggerProcessor.putPOJO("locationInfo", locationInfoMap);
            }
            loggerProcessor.put("timestamp", this.getFormattedTimestamp(loggerTimestamp));
            loggerProcessor.put("applicationName", this.configs.getConfig(configurationRef).getGlobalSettings().getApplicationName());
            loggerProcessor.put("applicationVersion", this.configs.getConfig(configurationRef).getGlobalSettings().getApplicationVersion());
            loggerProcessor.put("environment", this.configs.getConfig(configurationRef).getGlobalSettings().getEnvironment());
            loggerProcessor.put("threadName", Thread.currentThread().getName());
            String finalLogBefore = this.printObjectToLog(loggerProcessor, priority.toString(), this.configs.getConfig(configurationRef).getJsonOutput().isPrettyPrint());
            Long finalInitialTimestamp = initialTimestamp;
            operations.process(result -> {
                Long endScopeTimestamp = System.currentTimeMillis();
                Long scopeElapsed = endScopeTimestamp - loggerTimestamp;
                Long mainElapsed = endScopeTimestamp - finalInitialTimestamp;
                loggerProcessor.put("tracePoint", scopeTracePoint.toString() + "_AFTER");
                loggerProcessor.put("priority", priority.toString());
                loggerProcessor.put("elapsed", mainElapsed);
                loggerProcessor.put("scopeElapsed", scopeElapsed);
                loggerProcessor.put("timestamp", this.getFormattedTimestamp(endScopeTimestamp));
                String finalLogAfter = this.printObjectToLog(loggerProcessor, priority.toString(), this.configs.getConfig(configurationRef).getJsonOutput().isPrettyPrint());
                if (this.configs.getConfig(configurationRef).getExternalDestination() != null) {
                    this.publishScopeLogEvents(configurationRef, correlationId, finalLogBefore, finalLogAfter);
                }
                callback.success(result);
            }, (error, previous) -> {
                Long errorScopeTimestamp = System.currentTimeMillis();
                Long mainElapsed = errorScopeTimestamp - finalInitialTimestamp;
                Long scopeElapsed = errorScopeTimestamp - loggerTimestamp;
                loggerProcessor.put("message", "Error found: " + error.getMessage());
                loggerProcessor.put("tracePoint", "EXCEPTION_SCOPE");
                loggerProcessor.put("priority", "ERROR");
                loggerProcessor.put("elapsed", mainElapsed);
                loggerProcessor.put("scopeElapsed", scopeElapsed);
                loggerProcessor.put("timestamp", this.getFormattedTimestamp(errorScopeTimestamp));
                String finalLogError = this.printObjectToLog(loggerProcessor, "ERROR", this.configs.getConfig(configurationRef).getJsonOutput().isPrettyPrint());
                if (this.configs.getConfig(configurationRef).getExternalDestination() != null) {
                    this.publishScopeLogEvents(configurationRef, correlationId, finalLogBefore, finalLogError);
                }
                callback.error(error);
            });
        } else {
            LOGGER.debug("Avoiding logger scope logic execution due to log priority not being enabled");
            operations.process(result -> callback.success(result), (error, previous) -> callback.error(error));
        }
    }

    private void publishScopeLogEvents(String configurationRef, String correlationId, String finalLogBefore, String finalLogAfter) {
        LOGGER.debug("externalDestination.getDestination().getSupportedCategories().isEmpty(): " + this.configs.getConfig(configurationRef).getExternalDestination().getSupportedCategories().isEmpty());
        LOGGER.debug("externalDestination.getDestination().getSupportedCategories().contains(jsonLogger.getName()): " + this.configs.getConfig(configurationRef).getExternalDestination().getSupportedCategories().contains(this.jsonLogger.getName()));
        if (this.configs.getConfig(configurationRef).getExternalDestination().getSupportedCategories().isEmpty() || this.configs.getConfig(configurationRef).getExternalDestination().getSupportedCategories().contains(this.jsonLogger.getName())) {
            LOGGER.debug(this.jsonLogger.getName() + " is a supported category for external destination");
            this.logEvent.publishToExternalDestination(correlationId, finalLogBefore, configurationRef);
            this.logEvent.publishToExternalDestination(correlationId, finalLogAfter, configurationRef);
        }
    }

    private Map<String, String> locationInfoToMap(ComponentLocation location) {
        HashMap<String, String> locationInfo = new HashMap<String, String>();
        locationInfo.put("rootContainer", location.getRootContainerName());
        locationInfo.put("component", location.getComponentIdentifier().getIdentifier().toString());
        locationInfo.put("fileName", location.getFileName().orElse(""));
        locationInfo.put("lineInFile", String.valueOf(location.getLineInFile().orElse(null)));
        return locationInfo;
    }

    private String getFormattedTimestamp(Long loggerTimestamp) {
        DateTime dateTime = new DateTime((Object)loggerTimestamp).withZone(DateTimeZone.forID((String)System.getProperty("json.logger.timezone", "UTC")));
        String timestamp = dateTime.toString();
        if (System.getProperty("json.logger.dateformat") != null && !System.getProperty("json.logger.dateformat").equals("")) {
            timestamp = dateTime.toString(System.getProperty("json.logger.dateformat"));
        }
        return timestamp;
    }

    private String printObjectToLog(ObjectNode loggerObj, String priority, boolean isPrettyPrint) {
        ObjectWriter ow = isPrettyPrint ? this.om.getObjectMapper().writer().withDefaultPrettyPrinter() : this.om.getObjectMapper().writer();
        String logLine = "";
        try {
            logLine = ow.writeValueAsString((Object)loggerObj);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing log data as a string", (Throwable)e);
        }
        this.doLog(priority.toString(), logLine);
        return logLine;
    }

    private void doLog(String priority, String logLine) {
        switch (priority) {
            case "TRACE": {
                this.jsonLogger.trace(logLine);
                break;
            }
            case "DEBUG": {
                this.jsonLogger.debug(logLine);
                break;
            }
            case "INFO": {
                this.jsonLogger.info(logLine);
                break;
            }
            case "WARN": {
                this.jsonLogger.warn(logLine);
                break;
            }
            case "ERROR": {
                this.jsonLogger.error(logLine);
            }
        }
    }

    private Boolean isLogEnabled(String priority) {
        switch (priority) {
            case "TRACE": {
                return this.jsonLogger.isTraceEnabled();
            }
            case "DEBUG": {
                return this.jsonLogger.isDebugEnabled();
            }
            case "INFO": {
                return this.jsonLogger.isInfoEnabled();
            }
            case "WARN": {
                return this.jsonLogger.isWarnEnabled();
            }
            case "ERROR": {
                return this.jsonLogger.isErrorEnabled();
            }
        }
        return false;
    }

    protected void initLoggerCategory(String category) {
        this.jsonLogger = category != null ? LoggerFactory.getLogger((String)category) : LoggerFactory.getLogger((String)"org.mule.extension.jsonlogger.JsonLogger");
        LOGGER.debug("category set: " + this.jsonLogger.getName());
    }

    private static class TimerRemoverRunnable
    implements Runnable {
        private final String key;
        private final JsonloggerConfiguration config;

        public TimerRemoverRunnable(String key, JsonloggerConfiguration config) {
            this.key = key;
            this.config = config;
        }

        @Override
        public void run() {
            LOGGER.debug("Removing key: " + this.key);
            this.config.removeCachedTimerTimestamp(this.key);
        }
    }
}

