/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.internal.destinations;

import com.mule.extensions.amqp.api.message.AmqpMessageBuilder;
import com.mule.extensions.amqp.api.message.AmqpProperties;
import java.util.ArrayList;
import javax.inject.Inject;
import org.mule.extension.jsonlogger.internal.destinations.Destination;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.client.DefaultOperationParameters;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPDestination
implements Destination {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQPDestination.class);
    @Inject
    ExtensionsClient extensionsClient;
    @Parameter
    @Optional
    @ConfigReference(namespace="AMQP", name="CONFIG")
    @DisplayName(value="Configuration Ref")
    private String amqpConfigurationRef;
    @Parameter
    @Optional
    @Summary(value="Name of the target exchange destination (e.g. logger-exchange)")
    @DisplayName(value="Exchange Destination")
    private String exchangeDestination;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="Indicate which log categories should be send (e.g. [\"my.category\",\"another.category\"]). If empty, all will be send.")
    @DisplayName(value="Log Categories")
    private ArrayList<String> logCategories;
    @Parameter
    @Optional(defaultValue="25")
    @Summary(value="Indicate max quantity of logs entries to be send to the external destination")
    @DisplayName(value="Max Batch Size")
    private int maxBatchSize;

    @Override
    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    public String getSelectedDestinationType() {
        return "AMQP";
    }

    @Override
    public ArrayList<String> getSupportedCategories() {
        return this.logCategories;
    }

    @Override
    public void sendToExternalDestination(String finalLog) {
        try {
            DefaultOperationParameters parameters = DefaultOperationParameters.builder().configName(this.amqpConfigurationRef).addParameter("exchangeName", (Object)this.exchangeDestination).addParameter("messageBuilder", AmqpMessageBuilder.class, DefaultOperationParameters.builder().addParameter("body", (Object)new TypedValue((Object)finalLog, DataType.JSON_STRING)).addParameter("properties", (Object)new AmqpProperties())).build();
            this.extensionsClient.executeAsync("AMQP", "publish", (OperationParameters)parameters);
        }
        catch (Exception e) {
            LOGGER.error("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void initialise() {
    }

    @Override
    public void dispose() {
    }
}

