/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.internal.datamask;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class JsonMasker {
    private static final Pattern digits = Pattern.compile("\\d");
    private static final Pattern capitalLetters = Pattern.compile("[A-Z]");
    private static final Pattern nonSpecialCharacters = Pattern.compile("[^X\\s!-/:-@\\[-`{-~]");
    private static final Configuration jsonPathConfig = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).options(new Option[]{Option.AS_PATH_LIST, Option.SUPPRESS_EXCEPTIONS}).build();
    private final Set<String> blacklistedKeys;
    private final Set<JsonPath> blacklistedJsonPaths;
    private final boolean enabled;

    public JsonMasker(Collection<String> blacklist, boolean enabled) {
        this.enabled = enabled;
        this.blacklistedKeys = new HashSet<String>();
        this.blacklistedJsonPaths = new HashSet<JsonPath>();
        blacklist.forEach(item -> {
            if (item.startsWith("$")) {
                this.blacklistedJsonPaths.add(JsonPath.compile((String)item, (Predicate[])new Predicate[0]));
            } else {
                this.blacklistedKeys.add(item.toUpperCase());
            }
        });
    }

    public JsonMasker() {
        this(Collections.emptySet(), true);
    }

    public JsonMasker(boolean enabled) {
        this(Collections.emptySet(), enabled);
    }

    public JsonMasker(Collection<String> blacklist) {
        this(blacklist, true);
    }

    public JsonNode mask(JsonNode target) {
        if (!this.enabled) {
            return target;
        }
        if (target == null) {
            return null;
        }
        HashSet<String> expandedBlacklistedPaths = new HashSet<String>();
        for (JsonPath jsonPath : this.blacklistedJsonPaths) {
            if (jsonPath.isDefinite()) {
                expandedBlacklistedPaths.add(jsonPath.getPath());
                continue;
            }
            for (JsonNode node : (ArrayNode)jsonPath.read((Object)target, jsonPathConfig)) {
                expandedBlacklistedPaths.add(node.asText());
            }
        }
        return this.traverseAndMask(target.deepCopy(), expandedBlacklistedPaths, "$", false);
    }

    private JsonNode traverseAndMask(JsonNode target, Set<String> expandedBlacklistedPaths, String path, Boolean isBlackListed) {
        if (target.isTextual() && isBlackListed.booleanValue()) {
            return new TextNode(JsonMasker.maskString(target.asText()));
        }
        if (target.isNumber() && isBlackListed.booleanValue()) {
            return new TextNode(JsonMasker.maskNumber(target.asText()));
        }
        if (target.isObject()) {
            Iterator fields = target.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                String childPath = JsonMasker.appendPath(path, (String)field.getKey());
                if (this.blacklistedKeys.contains(((String)field.getKey()).toUpperCase()) || expandedBlacklistedPaths.contains(childPath) || isBlackListed.booleanValue()) {
                    ((ObjectNode)target).replace((String)field.getKey(), this.traverseAndMask((JsonNode)field.getValue(), expandedBlacklistedPaths, childPath, true));
                    continue;
                }
                ((ObjectNode)target).replace((String)field.getKey(), this.traverseAndMask((JsonNode)field.getValue(), expandedBlacklistedPaths, childPath, false));
            }
        }
        if (target.isArray()) {
            for (int i = 0; i < target.size(); ++i) {
                String childPath = JsonMasker.appendPath(path, i);
                if (expandedBlacklistedPaths.contains(childPath) || isBlackListed.booleanValue()) {
                    ((ArrayNode)target).set(i, this.traverseAndMask(target.get(i), expandedBlacklistedPaths, childPath, true));
                    continue;
                }
                ((ArrayNode)target).set(i, this.traverseAndMask(target.get(i), expandedBlacklistedPaths, childPath, false));
            }
        }
        return target;
    }

    private static String appendPath(String path, String key) {
        return path + "['" + key + "']";
    }

    private static String appendPath(String path, int ind) {
        return path + "[" + ind + "]";
    }

    private static String maskString(String value) {
        String tmpMasked = digits.matcher(value).replaceAll("*");
        tmpMasked = capitalLetters.matcher(tmpMasked).replaceAll("X");
        return nonSpecialCharacters.matcher(tmpMasked).replaceAll("x");
    }

    private static String maskNumber(String value) {
        return value.replaceAll("[0-9]", "*");
    }
}

