/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.internal.destinations;

import com.mulesoft.mq.restclient.AnypointMqClient;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.CourierAuthenticationCredentials;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import com.mulesoft.mq.restclient.internal.CourierObserver;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.DestinationLocator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import org.mule.extension.jsonlogger.internal.destinations.Destination;
import org.mule.extension.jsonlogger.internal.destinations.amq.client.MuleBasedAnypointMQClientFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQDestination
implements Destination {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQDestination.class);
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Name of the target queue or exchange destination (e.g. logger-queue, logger-exchange)")
    @DisplayName(value="Queue or Exchange Destination")
    private String queueOrExchangeDestination;
    @Parameter
    @DisplayName(value="URL")
    @Example(value="https://mq-us-east-1.anypoint.mulesoft.com/api/v1")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="https://mq-us-east-1.anypoint.mulesoft.com/api/v1")
    @Summary(value="The region URL where the Queue resides. Obtain this URL from the Anypoint Platform > MQ")
    private String url;
    @Parameter
    @DisplayName(value="Client App ID")
    @Summary(value="The Client App ID to be used. Obtain this ID from Anypoint Platform > MQ > Client Apps")
    private String clientId;
    @Parameter
    @DisplayName(value="Client Secret")
    @Password
    @Summary(value="The Client App Secret for the given Client App ID")
    private String clientSecret;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    @Summary(value="Indicate which log categories should be send (e.g. [\"my.category\",\"another.category\"]). If empty, all will be send.")
    @DisplayName(value="Log Categories")
    private ArrayList<String> logCategories;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="25")
    @Summary(value="Indicate max quantity of logs entries to be send to the external destination")
    @DisplayName(value="Max Batch Size")
    private int maxBatchSize;
    @Inject
    protected HttpService httpService;
    @Inject
    protected SchedulerService schedulerService;
    private final String AMQ_HTTP_CLIENT = "amqHttpClient";
    private final String USER_AGENT_VERSION = "3.1.0";
    private HttpClientConfiguration httpClientConfiguration;
    private HttpClient httpClient;
    private AnypointMqClient amqClient;
    private DestinationLocator destinationLocator;
    private DestinationLocation location;

    @Override
    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    public String getSelectedDestinationType() {
        return "AMQ";
    }

    @Override
    public ArrayList<String> getSupportedCategories() {
        return this.logCategories;
    }

    @Override
    public void sendToExternalDestination(String finalLog) {
        try {
            MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
            AnypointMQMessage message = AMQDestination.createMessage(finalLog, true, mediaType.toString(), mediaType.getCharset(), null, new HashMap<String, Object>(), null, null);
            this.destinationLocator.getDestination(this.location).send(message, false, 1).subscribe((CourierObserver)new CourierObserver<MessageIdResult>(){

                public void onSuccess(MessageIdResult result) {
                    LOGGER.debug("AMQ Message Id: " + result.getMessageId());
                }

                public void onError(Throwable e) {
                    String msg = String.format("Failed to publish message to destination '%s': %s", AMQDestination.this.location, e.getMessage());
                    LOGGER.error(msg, e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error sending message to AMQ: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static AnypointMQMessage createMessage(String messageBody, boolean sendContentType, String mediaType, Optional<Charset> charset, String messageId, Map<String, Object> properties, Optional<Long> deliveryDelay, Optional<String> messageGroupId) {
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.withBody((InputStream)new ByteArrayInputStream(messageBody.getBytes()));
        String id = Optional.ofNullable(messageId).orElseGet(UUID::randomUUID).toString();
        messageBuilder.withMessageId(id);
        if (sendContentType) {
            messageBuilder.addProperty("contentType", (Object)mediaType);
            charset.map(Object::toString).ifPresent(value -> messageBuilder.addProperty("MULE_ENCODING", value));
        }
        if (properties != null) {
            messageBuilder.withProperties(properties);
        }
        return messageBuilder.build();
    }

    @Override
    public void initialise() {
        Long startTimestamp = System.currentTimeMillis();
        this.httpClientConfiguration = new HttpClientConfiguration.Builder().setName("amqHttpClient").build();
        this.httpClient = this.httpService.getClientFactory().create(this.httpClientConfiguration);
        this.httpClient.start();
        this.amqClient = new MuleBasedAnypointMQClientFactory(this.httpClient, this.schedulerService.ioScheduler()).createClient(this.url, (CourierAuthenticationCredentials)new OAuthCredentials(this.clientId, this.clientSecret), "3.1.0");
        this.amqClient.init();
        this.destinationLocator = this.amqClient.createDestinationLocator();
        this.location = this.destinationLocator.getDestinationLocation(this.queueOrExchangeDestination);
    }

    @Override
    public void dispose() {
        this.httpClient.stop();
        this.amqClient.dispose();
    }
}

