/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.api.pojos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TracePoint {
    START("START"),
    BEFORE_TRANSFORM("BEFORE_TRANSFORM"),
    AFTER_TRANSFORM("AFTER_TRANSFORM"),
    BEFORE_REQUEST("BEFORE_REQUEST"),
    AFTER_REQUEST("AFTER_REQUEST"),
    FLOW("FLOW"),
    END("END"),
    EXCEPTION("EXCEPTION");

    private final String value;
    private static final Map<String, TracePoint> CONSTANTS;

    private TracePoint(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TracePoint fromValue(String value) {
        TracePoint constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TracePoint>();
        for (TracePoint c : TracePoint.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

