/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.internal.destinations.amq.client;

import com.mulesoft.mq.restclient.client.Request;
import com.mulesoft.mq.restclient.client.RequestBuilder;
import com.mulesoft.mq.restclient.client.Response;
import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AsyncMuleCourierRestClient
extends AbstractCourierRestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMuleCourierRestClient.class);
    private static final int RESPONSE_TIMEOUT_MILLIS = 60000;
    private final HttpClient httpClient;
    private final Scheduler scheduler;

    public AsyncMuleCourierRestClient(String courierApiUrl, OAuthCredentials oAuthCredentials, String userAgentInfo, HttpClient httpClient, Scheduler scheduler) {
        super(courierApiUrl, oAuthCredentials, userAgentInfo);
        this.httpClient = httpClient;
        this.scheduler = scheduler;
    }

    protected Observable<Response> process(Request request) {
        this.logProcessStart(request);
        return Observable.create(subscriber -> this.httpClient.sendAsync(((MuleBasedRequest)request).getHttpRequest(), HttpRequestOptions.builder().responseTimeout(60000).followsRedirect(true).build()).whenCompleteAsync((response, exception) -> {
            if (exception != null) {
                this.logProcessError(request, (Throwable)exception);
                subscriber.onError(exception);
            } else {
                try {
                    Response mqResponse = AsyncMuleCourierRestClient.convert(response);
                    this.logProcessSuccess(request, mqResponse);
                    subscriber.onNext((Object)mqResponse);
                }
                finally {
                    subscriber.onCompleted();
                }
            }
        }, command -> {
            try {
                this.scheduler.submit(command);
            }
            catch (Exception e) {
                subscriber.onError((Throwable)e);
                LOGGER.debug("An error occurred while processing the request: " + e.getMessage());
            }
        }));
    }

    protected static Response convert(final HttpResponse httpResponse) {
        return new Response(){

            public String getBody() {
                String string;
                block8: {
                    InputStream stream = httpResponse.getEntity().getContent();
                    try {
                        string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Can not retrieve response body.", e);
                        }
                    }
                    stream.close();
                }
                return string;
            }

            public boolean isOk() {
                return this.getStatusCode() >= 200 && this.getStatusCode() < 300;
            }

            public String getStatusText() {
                return httpResponse.getReasonPhrase();
            }

            public int getStatusCode() {
                return httpResponse.getStatusCode();
            }

            public String getHeader(String name) {
                return httpResponse.getHeaderValue(name);
            }

            public boolean isUnauthorized() {
                return this.getStatusCode() == 401;
            }
        };
    }

    protected RequestBuilder newRequestBuilder() {
        return new RequestBuilder(){
            private HttpRequestBuilder httpRequestBuilder = HttpRequest.builder();
            private MultiMap<String, String> queryParams = new MultiMap();
            private HttpEntity entity;

            public RequestBuilder wrap(Request request) {
                MuleBasedRequest muleBasedRequest = (MuleBasedRequest)request;
                this.use(request.getMethod());
                this.to(request.getUrl());
                this.queryParams = muleBasedRequest.httpRequest.getQueryParams();
                this.entity = muleBasedRequest.httpRequest.getEntity();
                return this;
            }

            public RequestBuilder use(RequestBuilder.Method method) {
                this.httpRequestBuilder.method(method.name());
                return this;
            }

            public RequestBuilder to(String url) {
                this.httpRequestBuilder.uri(url);
                return this;
            }

            public RequestBuilder withBody(String body) {
                this.entity = new ByteArrayHttpEntity(body.getBytes());
                return this;
            }

            public RequestBuilder withHeader(String name, String value) {
                this.httpRequestBuilder.addHeader(name, value);
                return this;
            }

            public RequestBuilder withFormParam(String name, String value) {
                if (!(this.entity instanceof MultipartHttpEntity)) {
                    this.entity = new MultipartHttpEntity(new ArrayList());
                }
                ((MultipartHttpEntity)this.entity).getParts().add(new HttpPart(name, value.getBytes(), null, 0));
                return this;
            }

            public RequestBuilder withQueryParam(String name, String value) {
                this.queryParams.put((Object)name, (Object)value);
                return this;
            }

            public RequestBuilder waitingUpTo(long duration, TimeUnit unit) {
                return this;
            }

            public Request build() {
                this.httpRequestBuilder.queryParams(this.queryParams);
                if (this.entity != null) {
                    this.httpRequestBuilder.entity(this.entity);
                }
                return new MuleBasedRequest(this.httpRequestBuilder.build());
            }
        };
    }

    class MuleBasedRequest
    implements Request {
        private HttpRequest httpRequest;

        public MuleBasedRequest(HttpRequest httpRequest) {
            this.httpRequest = httpRequest;
        }

        public RequestBuilder.Method getMethod() {
            return RequestBuilder.Method.valueOf((String)this.httpRequest.getMethod());
        }

        public String getUrl() {
            return this.httpRequest.getUri().toString();
        }

        public HttpRequest getHttpRequest() {
            return this.httpRequest;
        }

        public String toString() {
            return this.httpRequest.toString();
        }
    }
}

