/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.internal.destinations.events;

import com.lmax.disruptor.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.extension.jsonlogger.internal.destinations.Destination;
import org.mule.extension.jsonlogger.internal.destinations.events.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEventHandler
implements EventHandler<LogEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogEventHandler.class);
    private Map<String, List<String>> aggregatedLogsPerConfig = new HashMap<String, List<String>>();
    private Map<String, Destination> destinations = new HashMap<String, Destination>();

    public LogEventHandler(Map<String, Destination> destinations) {
        this.destinations = destinations;
    }

    public void onEvent(LogEvent logEvent, long sequence, boolean endOfBatch) {
        LOGGER.debug("Event Log received with correlationId: " + logEvent.getCorrelationId());
        if (this.aggregatedLogsPerConfig.get(logEvent.getConfigName()) == null) {
            ArrayList<String> aggregatedLogs = new ArrayList<String>();
            aggregatedLogs.add(logEvent.getLog());
            this.aggregatedLogsPerConfig.put(logEvent.getConfigName(), aggregatedLogs);
        } else {
            this.aggregatedLogsPerConfig.get(logEvent.getConfigName()).add(logEvent.getLog());
        }
        if (this.aggregatedLogsPerConfig.get(logEvent.getConfigName()).size() >= this.destinations.get(logEvent.getConfigName()).getMaxBatchSize()) {
            LOGGER.debug("Max batch size of " + this.destinations.get(logEvent.getConfigName()).getMaxBatchSize() + " reached for Config: " + logEvent.getConfigName() + ". Flushing logs...");
            this.flushLogs(logEvent.getConfigName());
        }
        if (endOfBatch) {
            LOGGER.debug("End of batch reached. Flushing all config logs...");
            this.flushAllLogs();
        }
    }

    private void flushLogs(String configName) {
        LOGGER.debug("Sending " + this.aggregatedLogsPerConfig.get(configName).size() + " logs to external destination: " + this.destinations.get(configName).getSelectedDestinationType());
        try {
            this.destinations.get(configName).sendToExternalDestination(this.aggregatedLogsPerConfig.get(configName).toString());
        }
        catch (Exception e) {
            LOGGER.error("Error flushing aggregated logs: " + e.getMessage());
            e.printStackTrace();
        }
        this.aggregatedLogsPerConfig.get(configName).clear();
    }

    public void flushAllLogs() {
        try {
            for (String configName : this.aggregatedLogsPerConfig.keySet()) {
                if (this.aggregatedLogsPerConfig.get(configName).size() <= 0) continue;
                this.flushLogs(configName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error flushing all aggregated logs: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

