/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.api.pojos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Priority {
    DEBUG("DEBUG"),
    TRACE("TRACE"),
    INFO("INFO"),
    WARN("WARN"),
    ERROR("ERROR");

    private final String value;
    private static final Map<String, Priority> CONSTANTS;

    private Priority(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Priority fromValue(String value) {
        Priority constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Priority>();
        for (Priority c : Priority.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

