/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.internal;

import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.mule.extension.jsonlogger.api.pojos.LoggerConfig;
import org.mule.extension.jsonlogger.internal.JsonloggerOperations;
import org.mule.extension.jsonlogger.internal.destinations.Destination;
import org.mule.extension.jsonlogger.internal.singleton.ConfigsSingleton;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Operations(value={JsonloggerOperations.class})
public class JsonloggerConfiguration
extends LoggerConfig
implements Initialisable,
Disposable {
    @Inject
    ConfigsSingleton configsSingleton;
    @RefName
    private String configName;
    @Parameter
    @Optional
    @Placement(tab="Destinations")
    private Destination externalDestination;
    public ConcurrentHashMap<String, Long> timers = new ConcurrentHashMap();

    public String getConfigName() {
        return this.configName;
    }

    public ConcurrentHashMap<String, Long> getTimers() {
        return this.timers;
    }

    public void setTimers(ConcurrentHashMap<String, Long> timers) {
        this.timers = timers;
    }

    public void printTimersKeys() {
        System.out.println("Current timers: " + this.timers);
    }

    public Long getCachedTimerTimestamp(String key, Long initialTimeStamp) throws Exception {
        Long startTimestamp = this.timers.putIfAbsent(key, initialTimeStamp);
        return startTimestamp == null ? this.timers.get(key) : startTimestamp;
    }

    public void removeCachedTimerTimestamp(String key) {
        this.timers.remove(key);
    }

    public void setExternalDestination(Destination externalDestination) {
        this.externalDestination = externalDestination;
    }

    public Destination getExternalDestination() {
        return this.externalDestination;
    }

    public void initialise() throws InitialisationException {
        if (this.externalDestination != null) {
            this.externalDestination.initialise();
        }
        this.configsSingleton.addConfig(this.configName, this);
    }

    public void dispose() {
        if (this.externalDestination != null) {
            this.externalDestination.dispose();
        }
    }
}

