/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.internal.singleton;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.LiteTimeoutBlockingWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.util.HashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.extension.jsonlogger.internal.destinations.Destination;
import org.mule.extension.jsonlogger.internal.destinations.events.LogEvent;
import org.mule.extension.jsonlogger.internal.destinations.events.LogEventHandler;
import org.mule.extension.jsonlogger.internal.singleton.ConfigsSingleton;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEventSingleton
implements Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogEventSingleton.class);
    private final Integer BUFFER_SIZE = Integer.valueOf(System.getProperty("json.logger.destinations.buffersize", "1024"));
    private final Integer WAIT_TIMEOUT = Integer.valueOf(System.getProperty("json.logger.destinations.waittimeout", "100"));
    @Inject
    ConfigsSingleton configs;
    private HashMap<String, Destination> destinations = new HashMap();
    private Disruptor<LogEvent> disruptor;
    private RingBuffer<LogEvent> ringBuffer;
    private LogEventHandler logEventHandler;

    public static void translate(LogEvent logEvent, long sequence, String correlationId, String log, String configName) {
        logEvent.setLogEvent(correlationId, log, configName);
    }

    public void publishToExternalDestination(String correlationId, String finalLog, String configName) {
        LOGGER.debug("Publishing event to ringBuffer for destination type: " + this.destinations.get(configName).getSelectedDestinationType());
        this.ringBuffer.publishEvent(LogEventSingleton::translate, (Object)correlationId, (Object)finalLog, (Object)configName);
    }

    public void initialise() throws InitialisationException {
        LOGGER.debug("Init LogEventSingleton...");
        LiteTimeoutBlockingWaitStrategy waitStrategy = new LiteTimeoutBlockingWaitStrategy((long)this.WAIT_TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
        this.disruptor = new Disruptor(LogEvent::new, this.BUFFER_SIZE.intValue(), (ThreadFactory)DaemonThreadFactory.INSTANCE, ProducerType.SINGLE, (WaitStrategy)waitStrategy);
        this.configs.getConfigs().forEach((configName, config) -> this.destinations.put((String)configName, config.getExternalDestination()));
        this.logEventHandler = new LogEventHandler(this.destinations);
        this.disruptor.handleEventsWith(new EventHandler[]{this.logEventHandler});
        this.disruptor.start();
        this.ringBuffer = this.disruptor.getRingBuffer();
    }

    public void dispose() {
        this.disruptor.shutdown();
        this.logEventHandler.flushAllLogs();
    }
}

