/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.api.pojos;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"prettyPrint", "logLocationInfo", "parseContentFieldsInJsonOutput", "disabledFields", "contentFieldsDataMasking"})
public class JsonOutput {
    @JsonProperty(value="prettyPrint")
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicate if log entries should be formatted or single line")
    @Expression(value=ExpressionSupport.SUPPORTED)
    private boolean prettyPrint;
    @JsonProperty(value="logLocationInfo")
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicate if location information should be logged")
    @Expression(value=ExpressionSupport.SUPPORTED)
    private boolean logLocationInfo;
    @JsonProperty(value="parseContentFieldsInJsonOutput")
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicate if Content fields should be parsed as part of the JSON logger output")
    @Expression(value=ExpressionSupport.SUPPORTED)
    private boolean parseContentFieldsInJsonOutput;
    @JsonProperty(value="disabledFields")
    @Parameter
    @Optional
    @Summary(value="Indicate which fields (from JSON output) should be disabled from logging separated by comma. They should match the exact name given in loggerProcessor.json schema")
    @Example(value="message,content")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String disabledFields;
    @JsonProperty(value="contentFieldsDataMasking")
    @Parameter
    @Optional
    @Summary(value="Indicate which fields (inside a content type with JSON output only) should be masked before from logging separated by comma. They can be JSON keys or JSON paths. If empty, no masking will be applied. Recommendation: This value should be based on external property")
    @Example(value="client_secret,password,$.myArray[1].someField,$..path.to.a.field")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String contentFieldsDataMasking;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="prettyPrint")
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @JsonProperty(value="prettyPrint")
    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @JsonProperty(value="logLocationInfo")
    public boolean isLogLocationInfo() {
        return this.logLocationInfo;
    }

    @JsonProperty(value="logLocationInfo")
    public void setLogLocationInfo(boolean logLocationInfo) {
        this.logLocationInfo = logLocationInfo;
    }

    @JsonProperty(value="parseContentFieldsInJsonOutput")
    public boolean isParseContentFieldsInJsonOutput() {
        return this.parseContentFieldsInJsonOutput;
    }

    @JsonProperty(value="parseContentFieldsInJsonOutput")
    public void setParseContentFieldsInJsonOutput(boolean parseContentFieldsInJsonOutput) {
        this.parseContentFieldsInJsonOutput = parseContentFieldsInJsonOutput;
    }

    @JsonProperty(value="disabledFields")
    public String getDisabledFields() {
        return this.disabledFields;
    }

    @JsonProperty(value="disabledFields")
    public void setDisabledFields(String disabledFields) {
        this.disabledFields = disabledFields;
    }

    @JsonProperty(value="contentFieldsDataMasking")
    public String getContentFieldsDataMasking() {
        return this.contentFieldsDataMasking;
    }

    @JsonProperty(value="contentFieldsDataMasking")
    public void setContentFieldsDataMasking(String contentFieldsDataMasking) {
        this.contentFieldsDataMasking = contentFieldsDataMasking;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JsonOutput.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("prettyPrint");
        sb.append('=');
        sb.append(this.prettyPrint);
        sb.append(',');
        sb.append("logLocationInfo");
        sb.append('=');
        sb.append(this.logLocationInfo);
        sb.append(',');
        sb.append("parseContentFieldsInJsonOutput");
        sb.append('=');
        sb.append(this.parseContentFieldsInJsonOutput);
        sb.append(',');
        sb.append("disabledFields");
        sb.append('=');
        sb.append(this.disabledFields == null ? "<null>" : this.disabledFields);
        sb.append(',');
        sb.append("contentFieldsDataMasking");
        sb.append('=');
        sb.append(this.contentFieldsDataMasking == null ? "<null>" : this.contentFieldsDataMasking);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.prettyPrint ? 1 : 0);
        result = result * 31 + (this.disabledFields == null ? 0 : this.disabledFields.hashCode());
        result = result * 31 + (this.logLocationInfo ? 1 : 0);
        result = result * 31 + (this.parseContentFieldsInJsonOutput ? 1 : 0);
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.contentFieldsDataMasking == null ? 0 : this.contentFieldsDataMasking.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JsonOutput)) {
            return false;
        }
        JsonOutput rhs = (JsonOutput)other;
        return this.prettyPrint == rhs.prettyPrint && (this.disabledFields == rhs.disabledFields || this.disabledFields != null && this.disabledFields.equals(rhs.disabledFields)) && this.logLocationInfo == rhs.logLocationInfo && this.parseContentFieldsInJsonOutput == rhs.parseContentFieldsInJsonOutput && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.contentFieldsDataMasking == rhs.contentFieldsDataMasking || this.contentFieldsDataMasking != null && this.contentFieldsDataMasking.equals(rhs.contentFieldsDataMasking));
    }
}

