/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.jsonlogger.api.pojos;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.extension.jsonlogger.api.pojos.Priority;
import org.mule.extension.jsonlogger.api.pojos.TracePoint;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"correlationId", "message", "content", "tracePoint", "priority", "category"})
public class LoggerProcessor {
    @JsonProperty(value="correlationId")
    @Parameter
    @Optional(defaultValue="#[correlationId]")
    @Placement(tab="Advanced")
    private String correlationId;
    @JsonProperty(value="message")
    @Parameter
    @Summary(value="Message to be logged")
    @Example(value="Add a log message")
    private String message;
    @JsonProperty(value="content")
    @Parameter
    @Optional(defaultValue="#[import modules::JSONLoggerModule output application/json ---\n{\n    payload: JSONLoggerModule::stringifyNonJSON(payload) \n}]")
    @Summary(value="NOTE: Writing the entire payload every time across your application can cause serious performance issues")
    @Content
    private ParameterResolver<TypedValue<InputStream>> content;
    @JsonProperty(value="tracePoint")
    @Parameter
    @Optional(defaultValue="START")
    @Summary(value="Current processing stage")
    private TracePoint tracePoint;
    @JsonProperty(value="priority")
    @Parameter
    @Optional(defaultValue="INFO")
    @Summary(value="Logger priority")
    private Priority priority;
    @JsonProperty(value="category")
    @Parameter
    @Optional
    @Summary(value="If not set, by default will log to the org.mule.extension.jsonlogger.JsonLogger category")
    private String category;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="correlationId")
    public String getCorrelationId() {
        return this.correlationId;
    }

    @JsonProperty(value="correlationId")
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(value="content")
    public ParameterResolver<TypedValue<InputStream>> getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    public void setContent(ParameterResolver<TypedValue<InputStream>> content) {
        this.content = content;
    }

    @JsonProperty(value="tracePoint")
    public TracePoint getTracePoint() {
        return this.tracePoint;
    }

    @JsonProperty(value="tracePoint")
    public void setTracePoint(TracePoint tracePoint) {
        this.tracePoint = tracePoint;
    }

    @JsonProperty(value="priority")
    public Priority getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @JsonProperty(value="category")
    public String getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LoggerProcessor.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("correlationId");
        sb.append('=');
        sb.append(this.correlationId == null ? "<null>" : this.correlationId);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("content");
        sb.append('=');
        sb.append(this.content == null ? "<null>" : this.content);
        sb.append(',');
        sb.append("tracePoint");
        sb.append('=');
        sb.append(this.tracePoint == null ? "<null>" : this.tracePoint);
        sb.append(',');
        sb.append("priority");
        sb.append('=');
        sb.append(this.priority == null ? "<null>" : this.priority);
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = result * 31 + (this.tracePoint == null ? 0 : this.tracePoint.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.priority == null ? 0 : this.priority.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        result = result * 31 + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LoggerProcessor)) {
            return false;
        }
        LoggerProcessor rhs = (LoggerProcessor)other;
        return (this.correlationId == rhs.correlationId || this.correlationId != null && this.correlationId.equals(rhs.correlationId)) && (this.tracePoint == rhs.tracePoint || this.tracePoint != null && this.tracePoint.equals((Object)rhs.tracePoint)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.priority == rhs.priority || this.priority != null && this.priority.equals((Object)rhs.priority)) && (this.category == rhs.category || this.category != null && this.category.equals(rhs.category)) && (this.content == rhs.content || this.content != null && this.content.equals(rhs.content));
    }
}

