/*
 * Decompiled with CFR 0.152.
 */
package com.mule.whisperer.helpers;

import com.mule.whisperer.helpers.Mp3ToWavConverter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileReader {
    public static float[] readFile(File audioFile) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audioFile);
        ByteBuffer captureBuffer = ByteBuffer.allocate(audioInputStream.available());
        captureBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int bytesRead = audioInputStream.read(captureBuffer.array());
        if (bytesRead == -1) {
            throw new IOException("Unable to read audio file: " + audioFile.getAbsolutePath());
        }
        ShortBuffer shortBuffer = captureBuffer.asShortBuffer();
        float[] samples = new float[shortBuffer.capacity()];
        int i = 0;
        while (shortBuffer.hasRemaining()) {
            samples[i++] = Math.max(-1.0f, Math.min((float)shortBuffer.get() / 32767.0f, 1.0f));
        }
        return samples;
    }

    public static void convertMp3ToWav(String mp3FilePath, String wavFilePath) throws IOException, UnsupportedAudioFileException {
        Mp3ToWavConverter.convertMp3ToWav(mp3FilePath, wavFilePath);
    }
}

