/*
 * Decompiled with CFR 0.152.
 */
package com.mule.whisperer.internal;

import com.mule.whisperer.MuleChainVoiceConfiguration;
import com.mule.whisperer.helpers.AudioFileReader;
import com.mule.whisperer.helpers.LocalSTTParamsModelDetails;
import com.mule.whisperer.helpers.STTParamsModelDetails;
import com.mule.whisperer.helpers.TTSParamsModelDetails;
import com.mule.whisperer.helpers.WhisperContextHelper;
import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperFullParams;
import io.github.givimad.whisperjni.WhisperJNI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleChainVoiceOperations {
    private static final String API_URL = "https://api.openai.com/v1/audio/";
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleChainVoiceOperations.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MediaType(value="application/json", strict=false)
    @Alias(value="Speech-to-text-local")
    public InputStream speechToTextLocal(InputStream audioFile, @Config MuleChainVoiceConfiguration configuration, @ParameterGroup(name="Local properties") LocalSTTParamsModelDetails localParams) {
        JSONObject jsonResponse = new JSONObject();
        File tempAudioFile = null;
        LOGGER.info("Starting speech-to-text operation in local mode.");
        try {
            if (!configuration.isUseLocalWhisper()) {
                LOGGER.warn("Local Whisper mode not activated. Use the OpenAI API or enable the local option.");
                throw new RuntimeException("Local Whisper mode not activated. Use the OpenAI API or enable the local option.");
            }
            LOGGER.info("Local Whisper mode is enabled. Proceeding with loading the Whisper JNI library.");
            WhisperJNI.loadLibrary();
            WhisperJNI whisper = new WhisperJNI();
            WhisperContext ctx = WhisperContextHelper.getOrCreateWhisperContext(whisper, localParams.getModelPath());
            if (ctx == null) {
                LOGGER.error("Failed to initialize Whisper context.");
                throw new RuntimeException("Failed to initialize Whisper context");
            }
            WhisperFullParams params = new WhisperFullParams();
            params.nThreads = localParams.getNThreads();
            params.language = localParams.getLanguage();
            params.translate = localParams.isTranslate();
            params.printProgress = localParams.isPrintProgress();
            LOGGER.info("Whisper context initialized successfully. Processing audio input.");
            String appHomePath = System.getProperty("app.home");
            tempAudioFile = new File(appHomePath, "audio." + localParams.getAudioFormat().name().toLowerCase());
            try (FileOutputStream outStream = new FileOutputStream(tempAudioFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = audioFile.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
            }
            LOGGER.info("Audio file successfully saved to temporary file: {}", (Object)tempAudioFile.getAbsolutePath());
            String processedFilePath = tempAudioFile.getAbsolutePath();
            if (!localParams.getAudioFormat().equals((Object)LocalSTTParamsModelDetails.AudioFormat.WAV)) {
                LOGGER.info("Converting audio file to WAV format.");
                String wavFilePath = processedFilePath.replaceAll("\\.\\w+$", ".wav");
                AudioFileReader.convertMp3ToWav(processedFilePath, wavFilePath);
                processedFilePath = wavFilePath;
                LOGGER.info("Audio file converted to WAV format: {}", (Object)wavFilePath);
            }
            LOGGER.info("Reading audio file and extracting samples.");
            float[] samples = AudioFileReader.readFile(new File(processedFilePath));
            LOGGER.info("Performing speech-to-text operation with Whisper.");
            int result = whisper.full(ctx, params, samples, samples.length);
            if (result != 0) {
                LOGGER.error("Transcription failed with code {}", (Object)result);
                jsonResponse.put("error", (Object)("Transcription failed with code " + result));
            } else {
                StringBuilder transcription = new StringBuilder();
                int nSegments = whisper.fullNSegments(ctx);
                for (int i = 0; i < nSegments; ++i) {
                    transcription.append(whisper.fullGetSegmentText(ctx, i)).append(" ");
                }
                jsonResponse.put("transcription", (Object)transcription.toString().trim());
                LOGGER.info("Transcription completed successfully.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error during Speech-to-Text processing with Whisper: {}", (Object)e.getMessage(), (Object)e);
            jsonResponse.put("error", (Object)("Error during Speech-to-Text processing with Whisper: " + e.getMessage()));
        }
        finally {
            if (tempAudioFile != null && tempAudioFile.exists()) {
                if (tempAudioFile.delete()) {
                    LOGGER.info("Temporary file deleted successfully: {}", (Object)tempAudioFile.getAbsolutePath());
                } else {
                    LOGGER.warn("Failed to delete temporary file: {}", (Object)tempAudioFile.getAbsolutePath());
                }
            }
        }
        return IOUtils.toInputStream((String)jsonResponse.toString(), (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Speech-to-text")
    public InputStream speechToText(String audioFilePath, @Optional String finetuningPrompt, @Config MuleChainVoiceConfiguration configuration, @ParameterGroup(name="Additional properties") STTParamsModelDetails paramDetails) {
        JSONObject jsonResponse;
        try {
            File audioFile = new File(audioFilePath);
            URL url = new URL("https://api.openai.com/v1/audio/transcriptions");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Bearer " + configuration.getApiKey());
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW");
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                MuleChainVoiceOperations.writeMultipartData(os, audioFile, paramDetails.getModelName(), finetuningPrompt, paramDetails.getResponseFormat(), (Double)paramDetails.getTemperature(), paramDetails.getLanguage());
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                jsonResponse = new JSONObject(response.toString());
                System.out.println("Transcription: " + jsonResponse.toString(2));
            } else {
                String errorLine;
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                StringBuilder errorResponse = new StringBuilder();
                while ((errorLine = errorReader.readLine()) != null) {
                    errorResponse.append(errorLine);
                    System.out.println(errorLine);
                }
                errorReader.close();
                jsonResponse = new JSONObject();
                System.out.println("POST request failed. Response Code: " + responseCode);
                System.out.println("Error: " + errorResponse.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonResponse = new JSONObject();
        }
        return IOUtils.toInputStream((String)jsonResponse.toString(), (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Text-to-speech")
    public InputStream textToSpeech(String textToConvert, String pathToOutputFile, @Config MuleChainVoiceConfiguration configuration, @ParameterGroup(name="Additional properties") TTSParamsModelDetails paramDetails) {
        try {
            JSONObject jsonPayload = new JSONObject();
            jsonPayload.put("model", (Object)paramDetails.getModelName());
            jsonPayload.put("input", (Object)textToConvert);
            jsonPayload.put("voice", (Object)paramDetails.getVoice());
            jsonPayload.put("response_format", (Object)paramDetails.getResponseFormat());
            jsonPayload.put("speed", (Object)paramDetails.getSpeed());
            URL url = new URL("https://api.openai.com/v1/audio/speech");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Bearer " + configuration.getApiKey());
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonPayload.toString().getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                int bytesRead;
                InputStream in = connection.getInputStream();
                FileOutputStream fos = new FileOutputStream(pathToOutputFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
                fos.close();
                in.close();
                System.out.println("Speech synthesis succeeded. Output saved to " + pathToOutputFile);
            } else {
                String errorLine;
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                StringBuilder errorResponse = new StringBuilder();
                while ((errorLine = errorReader.readLine()) != null) {
                    errorResponse.append(errorLine);
                }
                errorReader.close();
                System.out.println("POST request failed. Response Code: " + responseCode);
                System.out.println("Error: " + errorResponse.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject responseJson = new JSONObject();
        responseJson.put("outputDirectory", (Object)pathToOutputFile);
        return IOUtils.toInputStream((String)responseJson.toString(), (Charset)StandardCharsets.UTF_8);
    }

    private static void writeMultipartData(OutputStream os, File audioFile, String model, String prompt, String responseFormat, double temperature, String language) throws IOException {
        String boundary = "----WebKitFormBoundary7MA4YWxkTrZu0gW";
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(os, "UTF-8"), true);
        writer.append("--").append(boundary).append("\r\n");
        writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(audioFile.getName()).append("\"\r\n");
        writer.append("Content-Type: audio/mpeg\r\n\r\n").flush();
        try (FileInputStream inputStream = new FileInputStream(audioFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
        }
        writer.append("\r\n").flush();
        writer.append("--").append(boundary).append("\r\n");
        writer.append("Content-Disposition: form-data; name=\"model\"\r\n\r\n");
        writer.append(model).append("\r\n").flush();
        if (prompt != null && !prompt.isEmpty()) {
            writer.append("--").append(boundary).append("\r\n");
            writer.append("Content-Disposition: form-data; name=\"prompt\"\r\n\r\n");
            writer.append(prompt).append("\r\n").flush();
        }
        writer.append("--").append(boundary).append("\r\n");
        writer.append("Content-Disposition: form-data; name=\"response_format\"\r\n\r\n");
        writer.append(responseFormat).append("\r\n").flush();
        writer.append("--").append(boundary).append("\r\n");
        writer.append("Content-Disposition: form-data; name=\"temperature\"\r\n\r\n");
        writer.append(String.valueOf(temperature)).append("\r\n").flush();
        if (!"auto".equals(language)) {
            writer.append("--").append(boundary).append("\r\n");
            writer.append("Content-Disposition: form-data; name=\"language\"\r\n\r\n");
            writer.append(language).append("\r\n").flush();
        }
        writer.append("--").append(boundary).append("--\r\n").flush();
    }
}

