/*
 * Decompiled with CFR 0.152.
 */
package com.mule.whisperer.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;

class Mp3ToWavConverter {
    Mp3ToWavConverter() {
    }

    public static void convertMp3ToWav(String mp3FilePath, String wavFilePath) throws IOException, UnsupportedAudioFileException {
        try (FileInputStream mp3Stream = new FileInputStream(mp3FilePath);
             FileOutputStream wavStream = new FileOutputStream(wavFilePath);){
            Header header;
            Bitstream bitstream = new Bitstream((InputStream)mp3Stream);
            Decoder decoder = new Decoder();
            AudioFormat baseFormat = null;
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            long totalFrames = 0L;
            while ((header = bitstream.readFrame()) != null) {
                SampleBuffer output = (SampleBuffer)decoder.decodeFrame(header, bitstream);
                if (baseFormat == null) {
                    baseFormat = new AudioFormat(header.frequency(), 16, output.getChannelCount(), true, false);
                }
                byte[] buffer = new byte[output.getBufferLength() * 2];
                for (int i = 0; i < output.getBufferLength(); ++i) {
                    short val = output.getBuffer()[i];
                    buffer[2 * i] = (byte)(val & 0xFF);
                    buffer[2 * i + 1] = (byte)((val & 0xFF00) >> 8);
                }
                byteOutputStream.write(buffer, 0, buffer.length);
                totalFrames += (long)output.getBufferLength();
                bitstream.closeFrame();
            }
            byte[] audioData = byteOutputStream.toByteArray();
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(audioData);
            AudioInputStream audioInputStream = new AudioInputStream(byteInputStream, baseFormat, audioData.length / baseFormat.getFrameSize());
            AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, wavStream);
        }
        catch (JavaLayerException e) {
            e.printStackTrace();
        }
    }
}

