/*
 * Decompiled with CFR 0.152.
 */
package com.mule.whisperer.helpers;

import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperJNI;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhisperContextHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhisperContextHelper.class);
    private static final Map<Path, WhisperContext> whisperContextCache = new ConcurrentHashMap<Path, WhisperContext>();

    public static WhisperContext getOrCreateWhisperContext(WhisperJNI whisper, Path modelPath) throws IOException {
        WhisperContext ctx = whisperContextCache.get(modelPath);
        if (ctx == null) {
            LOGGER.info("No existing context for model path: {}. Creating a new context.", (Object)modelPath);
            ctx = whisper.init(modelPath);
            if (ctx != null) {
                whisperContextCache.put(modelPath, ctx);
                LOGGER.info("New Whisper context created and cached for model path: {}", (Object)modelPath);
            } else {
                LOGGER.error("Failed to create Whisper context for model path: {}", (Object)modelPath);
            }
        }
        return ctx;
    }

    public static void closeWhisperContext(Path modelPath) {
        WhisperContext ctx = whisperContextCache.remove(modelPath);
        if (ctx != null) {
            ctx.close();
            LOGGER.info("Whisper context for model path {} has been closed and removed from the cache.", (Object)modelPath);
        }
    }
}

