/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.config.util;

import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.azure.AzureOpenAiChatModel;
import dev.langchain4j.model.huggingface.HuggingFaceChatModel;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.time.Duration;
import org.mule.extension.mulechain.internal.config.LangchainLLMConfiguration;
import org.mule.extension.mulechain.internal.llm.config.ConfigExtractor;

public final class LangchainLLMInitializerUtil {
    private LangchainLLMInitializerUtil() {
    }

    public static OpenAiChatModel createOpenAiChatModel(ConfigExtractor configExtractor, LangchainLLMConfiguration configuration) {
        String openaiApiKey = configExtractor.extractValue("OPENAI_API_KEY");
        long durationInSec = configuration.getLlmTimeoutUnit().toSeconds(configuration.getLlmTimeout());
        return OpenAiChatModel.builder().apiKey(openaiApiKey).modelName(configuration.getModelName()).maxTokens(Integer.valueOf(configuration.getMaxTokens())).temperature(Double.valueOf(configuration.getTemperature())).timeout(Duration.ofSeconds(durationInSec)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();
    }

    public static OpenAiChatModel createGroqOpenAiChatModel(ConfigExtractor configExtractor, LangchainLLMConfiguration configuration) {
        String groqApiKey = configExtractor.extractValue("GROQ_API_KEY");
        long durationInSec = configuration.getLlmTimeoutUnit().toSeconds(configuration.getLlmTimeout());
        return OpenAiChatModel.builder().baseUrl("https://api.groq.com/openai/v1").apiKey(groqApiKey).modelName(configuration.getModelName()).maxTokens(Integer.valueOf(configuration.getMaxTokens())).temperature(Double.valueOf(configuration.getTemperature())).timeout(Duration.ofSeconds(durationInSec)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();
    }

    public static MistralAiChatModel createMistralAiChatModel(ConfigExtractor configExtractor, LangchainLLMConfiguration configuration) {
        String mistralAiApiKey = configExtractor.extractValue("MISTRAL_AI_API_KEY");
        long durationInSec = configuration.getLlmTimeoutUnit().toSeconds(configuration.getLlmTimeout());
        return MistralAiChatModel.builder().apiKey(mistralAiApiKey).modelName(configuration.getModelName()).maxTokens(Integer.valueOf(configuration.getMaxTokens())).temperature(Double.valueOf(configuration.getTemperature())).timeout(Duration.ofSeconds(durationInSec)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();
    }

    public static OllamaChatModel createOllamaChatModel(ConfigExtractor configExtractor, LangchainLLMConfiguration configuration) {
        String ollamaBaseUrl = configExtractor.extractValue("OLLAMA_BASE_URL");
        long durationInSec = configuration.getLlmTimeoutUnit().toSeconds(configuration.getLlmTimeout());
        return OllamaChatModel.builder().baseUrl(ollamaBaseUrl).modelName(configuration.getModelName()).temperature(Double.valueOf(configuration.getTemperature())).timeout(Duration.ofSeconds(durationInSec)).build();
    }

    public static HuggingFaceChatModel createHuggingFaceChatModel(ConfigExtractor configExtractor, LangchainLLMConfiguration configuration) {
        String huggingFaceApiKey = configExtractor.extractValue("HUGGING_FACE_API_KEY");
        long durationInSec = configuration.getLlmTimeoutUnit().toSeconds(configuration.getLlmTimeout());
        return HuggingFaceChatModel.builder().accessToken(huggingFaceApiKey).modelId(configuration.getModelName()).timeout(Duration.ofSeconds(durationInSec)).temperature(Double.valueOf(configuration.getTemperature())).maxNewTokens(Integer.valueOf(configuration.getMaxTokens())).waitForModel(Boolean.valueOf(true)).build();
    }

    public static AnthropicChatModel createAnthropicChatModel(ConfigExtractor configExtractor, LangchainLLMConfiguration configuration) {
        String anthropicApiKey = configExtractor.extractValue("ANTHROPIC_API_KEY");
        long durationInSec = configuration.getLlmTimeoutUnit().toSeconds(configuration.getLlmTimeout());
        return AnthropicChatModel.builder().apiKey(anthropicApiKey).modelName(configuration.getModelName()).maxTokens(Integer.valueOf(configuration.getMaxTokens())).temperature(Double.valueOf(configuration.getTemperature())).timeout(Duration.ofSeconds(durationInSec)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();
    }

    public static AzureOpenAiChatModel createAzureOpenAiChatModel(ConfigExtractor configExtractor, LangchainLLMConfiguration configuration) {
        String azureOpenaiKey = configExtractor.extractValue("AZURE_OPENAI_KEY");
        String azureOpenaiEndpoint = configExtractor.extractValue("AZURE_OPENAI_ENDPOINT");
        String azureOpenaiDeploymentName = configExtractor.extractValue("AZURE_OPENAI_DEPLOYMENT_NAME");
        long durationInSec = configuration.getLlmTimeoutUnit().toSeconds(configuration.getLlmTimeout());
        return AzureOpenAiChatModel.builder().apiKey(azureOpenaiKey).endpoint(azureOpenaiEndpoint).deploymentName(azureOpenaiDeploymentName).maxTokens(Integer.valueOf(configuration.getMaxTokens())).temperature(Double.valueOf(configuration.getTemperature())).timeout(Duration.ofSeconds(durationInSec)).logRequestsAndResponses(Boolean.valueOf(true)).build();
    }
}

