/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.llm.config;

import java.util.Arrays;
import java.util.function.Function;
import org.mule.extension.mulechain.internal.config.LangchainLLMConfiguration;
import org.mule.extension.mulechain.internal.error.exception.ConfigValidationException;
import org.mule.extension.mulechain.internal.llm.config.ConfigExtractor;
import org.mule.extension.mulechain.internal.llm.config.EnvConfigExtractor;
import org.mule.extension.mulechain.internal.llm.config.FileConfigExtractor;

public enum ConfigType {
    ENV_VARIABLE("Environment Variables", configuration -> new EnvConfigExtractor()),
    CONFIG_JSON("Configuration Json", FileConfigExtractor::new);

    private final String value;
    private final Function<LangchainLLMConfiguration, ConfigExtractor> configExtractorFunction;

    private ConfigType(String value, Function<LangchainLLMConfiguration, ConfigExtractor> configExtractorFunction) {
        this.value = value;
        this.configExtractorFunction = configExtractorFunction;
    }

    public static ConfigType fromValue(String value) {
        return Arrays.stream(ConfigType.values()).filter(configType -> configType.value.equals(value)).findFirst().orElseThrow(() -> new ConfigValidationException("Unsupported Config Type: " + value));
    }

    public String getValue() {
        return this.value;
    }

    public Function<LangchainLLMConfiguration, ConfigExtractor> getConfigExtractorFunction() {
        return this.configExtractorFunction;
    }
}

